#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
#include <iomanip>

#include <set>

using namespace std;

#define all(v) v.begin(), v.end()
#define rall(v) v.rbegin(), v.rend()

#define ll long long
#define ld long double

constexpr ll kMaxN = 1e5, inf = 1e17;

template <typename T>
istream& operator>>(istream& is, vector<T>& v) {
    for (auto& e : v) {
        is >> e;
    }
    return is;
}

template <typename T>
ostream& operator<<(ostream& os, vector<T>& v) {
    for (const auto& e : v) {
        os << e << ' ';
    }
    return os;
}

struct P {
    ll x, y;
};

ll dis(P a, P b) {
    return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y);
}



void solve() {
    ll n;
    cin >> n;

    vector<P> a(n);
    for (int i = 0; i < n; ++i) {
        ll x, y;
        cin >> x >> y;
        a[i] = {x, y};
    }

    pair<P, P> ma = {{0, 0}, {0, 0}};
    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < n; ++j) {
            if (dis(a[i], a[j]) > dis(ma.first, ma.second)) {
                ma = {a[i], a[j]};
            }
        }
    }

    ll A = ma.second.y - ma.first.y;
    ll B = ma.first.x - ma.second.x;
    ll C = -ma.first.x*ma.second.y - -ma.first.y*ma.second.x;

    auto aa = A;
    A = -B;
    B = aa;

    //cout << A << ' ' << B << ' ' << C << '\n';
    ll c1 = -(A * ma.first.x + B * ma.first.y);
    ll c2 = -(A * ma.second.x + B * ma.second.y);

    cout << A << " " << B << " " << c1 << "\n";
    cout << A << " " << B << " " << c2 << "\n";

}


// void solve() { // I
//     int t; cin >> t;
//     if (t == 0) {
//         int n; cin >> n;
//         vector<int> a(n);
//         for (auto &i : a) cin >> i;
//
//         int v = 1;
//         for (int i = 2; i < n; i++) {
//             if (a[i] == a[i + 1]) {
//                 v = i + 1;
//                 break;
//             }
//         }
//     }
//     int n; cin >> n;
//
// }

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);


    ll t = 1;
    //cin >> t;

    while (t--) {
        solve();
    }

    return 0;
}