#include <iomanip>
#include <iostream>
#include <cmath>
#include <math.h>
#include <unordered_set>
#include <vector>

using ll = long long;

static std::string piano;
static std::string s;

void buildPiano() {
  for (int i = 0; i < 7; ++i) piano += "ABCDEFG";
  piano += "ABC";
}

bool play(int i, std::string const& s) {
  for (int j = 0; j < s.size(); ++j) {
    bool moved = false;
    for (int x = std::max(i - 3, 0); x <= std::min(i + 3, (int) piano.size() - 1); ++x) {
      if (s[j] == piano[x]) {
        i = x;
        moved = true;
      }
    }
    if (!moved) {
      return false;
    }
  }
  return true;
}

void solve2(std::string const& s) {
  char b_ch = s[0];
  for (size_t i = 0; i < piano.size(); ++i) {
    if (piano[i] == b_ch) {
      bool played = play(i, s);
      if (played) {
        std::cout << "yes\n";
        return;
      }
    }
  }
  std::cout << "no\n";
}

int main() {
  std::ios_base::sync_with_stdio(false);
  std::cin.tie(0);
  int n;
  std::cin >> n;
  buildPiano();
  for (int i = 0; i < n; ++i) {
    std::cin >> s;
    solve2(s);
  }
}
