#ifndef __APPLE__
#include <bits/allocator.h>
#pragma GCC target("avx2,popcnt")
#pragma GCC optimize("O3")
#endif
#include "bits/stdc++.h"
using namespace std;
using ll = long long;

vector<int> fact;
vector<int> inv_fact;
vector<int> suf_mul;

const int mod = (int) 1e9 + 7;

int MAXN = 1000000;

int pow(int a, int b) {
    int res = 1;
    while (b) {
        if (b & 1) {
            res = (res * 1ll * a) % mod;
        }
        a = (a * 1ll * a) % mod;
        b >>= 1;
    }
    return res;
}

int inv(int n) {
    return pow(n, mod - 2);
}

int c(int n, int k) {
    if (n < k || k < 0) return 0;
    return (((fact[n] * 1ll * inv_fact[k]) % mod) * inv_fact[n - k]) % mod;
}

void solve() {
    int p, m;
    cin >> p >> m;
    cout << (pow(2 * p + m - 1, 2 * p + m) * 1ll * inv(2 * p + m)) % mod << '\n';

    // int ans = 0;
    //
    // suf_mul.resize(p + m + 1);
    // suf_mul.back() = p + m;
    // for (int i = p + m - 1; i >= 0; --i) {
    //     suf_mul[i] = (suf_mul[i + 1] * 1ll * i) % mod;
    // }
    //
    // for (int i = 0; i <= p + m + 1; ++i) {
    //     for (int j = 0; j <= i - 2 && j <= m; ++j) {
    //         int cur = ((c(m, j) * 1ll * c(p, i - j - 1)) % mod * (i - j - 1)) % mod;
    //         cur = (cur * 1ll * inv(suf_mul[p + m - i + 1])) % mod;
    //         ans = ((ans * 1ll + cur * (i + 1)) * i) % mod;
    //     }
    // }
    //
    // cout << ans << '\n';
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    fact.resize(MAXN + 1);
    inv_fact.resize(MAXN + 1);
    suf_mul.resize(MAXN + 1);

    fact[0] = 1;
    for (int i = 1; i <= MAXN; ++i) {
        fact[i] = (fact[i - 1] * 1ll * i) % mod;
    }

    inv_fact.back() = inv(fact.back());
    for (int i = MAXN - 1; i >= 0; --i) {
        inv_fact[i] = (inv_fact[i + 1] * 1ll * (i + 1)) % mod;
    }

    ll t = 1;
    cin >> t;
    while (t--) {
        solve();
    }

}
