def to_coords(a):
    coords = {}
    n = len(a)
    mid = n // 2
    for i, row in enumerate(a):
        start = -mid + max(0, mid - i)
        for j, val in enumerate(row):
            x = start + j
            y = i - mid
            z = -x - y
            coords[(x, y, z)] = val
    return coords


def to_sota(coords):
    ys = [y for _, y, _ in coords]
    min_y, max_y = min(ys), max(ys)
    result = []
    for y in range(min_y, max_y + 1):
        row = [v for (x, yy, _), v in sorted(coords.items()) if yy == y]
        result.append(row)
    return result


def T(a):
    coords = to_coords(a)
    new = {(-x, y, -z): v for (x, y, z), v in coords.items()}
    return to_sota(new)


def L(a):
    coords = to_coords(a)
    new = {(-z, -x, -y): v for (x, y, z), v in coords.items()}
    return to_sota(new)


def R(a):
    coords = to_coords(a)
    new = {(-y, -z, -x): v for (x, y, z), v in coords.items()}
    return to_sota(new)


D6 = [[0] * 12 for _ in range(12)]

for i in range(6):
    for j in range(6):
        D6[i][j] = (i + j) % 6
for i in range(6):
    for j in range(6, 12):
        D6[i][j] = (i + j) % 6 + 6
for i in range(6, 12):
    for j in range(6, 12):
        D6[i][j] = (i - j) % 6
for i in range(6, 12):
    for j in range(6):
        D6[i][j] = ((j - 6 - i) % 6) + 6

mapping = {"R": 1, "L": 5, "T": 6}
how = {0: "", 1: "R", 2: "RR", 3: "RRR", 4: "LL", 5: "L", 6: "T", 7: "TR", 8: "TRR", 9: "TRRR", 10: "TLL", 11: "TL"}

n = int(input())

a = [list(map(int, input().split())) for _ in range(2 * n - 1)]

s = input()
composition = 0

for c in s:
    composition = D6[composition][mapping[c]]

for c in how[composition]:
    if c == 'R':
        a = R(a)
    elif c == 'L':
        a = L(a)
    elif c == 'T':
        a = T(a)

for i in a:
    for j in i:
        print(j, end=' ')
    print()
