#include <iostream>
#include <vector>
#include <algorithm>
#include <iomanip>
#include <string>
#include <random>
#include <typeinfo>
#include <map>
#include <set>
#include <cassert>
#include <queue>
#include <unordered_map>
#include <functional>

using std::cin, std::cout, std::cerr, std::endl;
using std::vector, std::queue, std::deque, std::array, std::string,
        std::map, std::set, std::unordered_map, std::tuple;
using std::istream, std::ostream;
using std::min, std::max;
using std::abs, std::sort;

template<typename T, typename V = T>
using pair = std::pair<T, V>;

// #pragma GCC optimize("O3")
// #pragma GCC optimize("unroll-loops")
// #pragma GCC target("avx2,popcnt,tune=native")

using ll = long long;
using ull = unsigned long long;
using dl = long double;

#define all(x) (x).begin(), (x).end()

template<typename T>
std::ostream &operator<<(std::ostream &out, const pair<T, T> &a) {
    out << '(' << a.first << ' ' << a.second << ')';
    return out;
}

template<typename T, typename V>
std::istream &operator>>(std::istream &in, pair<T, V> &a) {
    in >> a.first >> a.second;
    return in;
}

template<typename T>
std::istream &operator>>(std::istream &in, vector<T> &a) {
    for (size_t i = 0; i < a.size(); i++) {
        in >> a[i];
    }
    return in;
}

struct int_mod;

//template<typename T>
//concept StringLike = std::same_as<std::remove_cvref_t<T>, std::string> ||
//                     std::convertible_to<T, std::string_view>;
//
//template<typename T>
//concept Iterable = std::ranges::range<T> && (!StringLike<T>);
//
//template<Iterable Container>
//std::ostream &operator<<(std::ostream &out, const Container &container) {
//    using value_type = std::decay_t<decltype(*std::begin(container))>;
//
//    char separator = (std::is_arithmetic_v<value_type> || std::is_same_v<value_type, int_mod>)
//                     ? ' '
//                     : '\n';
//
//    for (const auto &i: container) {
//        out << i << separator;
//    }
//    return out;
//}

// c++17 version
template<typename T>
std::ostream &operator<<(std::ostream &out, const vector<T> &container) {
    char separator = (std::is_arithmetic_v<T> || std::is_same_v<T, int_mod>)
                     ? ' '
                     : '\n';

    for (const auto &i: container) {
        out << i << separator;
    }
    return out;
}

template<typename T>
bool mini(T &a, const T &b) {
    if (a > b) {
        a = b;
        return true;
    }
    return false;
}

template<typename T>
bool maxi(T &a, const T &b) {
    if (a < b) {
        a = b;
        return true;
    }
    return false;
}

template<typename T>
T binpow(const T &a, ll exp) {
    T res(1);
    T base = a;
    while (exp > 0) {
        if (exp & 1)
            res *= base;
        base *= base;
        exp /= 2;
    }
    return res;
}

struct int_mod {
    static const int MOD = 998'244'353;
private:
    int val;

public:
    int_mod() : val(0) {}

    int_mod(int x) {
        val = (x % MOD + MOD) % MOD;
    }

    int_mod(ll x) {
        val = (int) ((x % MOD + MOD) % MOD);
    }

    operator int() const {
        return val;
    }

    int_mod &operator+=(const int_mod &other) {
        val += other.val;
        if (val >= MOD)
            val -= MOD;
        return *this;
    }

    int_mod &operator-=(const int_mod &other) {
        val -= other.val;
        if (val < 0)
            val += MOD;
        return *this;
    }

    int_mod &operator*=(const int_mod &other) {
        val = static_cast<int>(static_cast<long long>(val) * other.val % MOD);
        return *this;
    }

    int_mod &operator/=(const int_mod &other) {
        return *this *= other.inv();
    }

    int_mod inv() const {
        return binpow(*this, MOD - 2);
    }

    friend int_mod operator+(int_mod a, const int_mod &b) {
        a += b;
        return a;
    }

    friend int_mod operator+(int_mod a, int b) {
        a += b;
        return a;
    }

    friend int_mod operator-(int_mod a, const int_mod &b) {
        a -= b;
        return a;
    }

    friend int_mod operator-(int_mod a, int b) {
        a -= b;
        return a;
    }

    friend int_mod operator*(int_mod a, const int_mod &b) {
        a *= b;
        return a;
    }

    friend int_mod operator*(int_mod a, int b) {
        a *= b;
        return a;
    }

    friend int_mod operator/(int_mod a, const int_mod &b) {
        a /= b;
        return a;
    }

    friend int_mod operator/(int_mod a, int_mod b) {
        a /= b;
        return a;
    }

    friend std::ostream &operator<<(std::ostream &os, const int_mod &m) {
        return os << m.val;
    }

    friend std::istream &operator>>(std::istream &is, int_mod &m) {
        int x;
        is >> x;
        m = int_mod(x);
        return is;
    }
};

struct point {
    ll x, y;

    friend istream& operator >> (istream& in, point& pt) {
        in >> pt.x >> pt.y;
        return in;
    }

    ll slen() const {
        return x * x + y * y;
    }

    friend point operator - (const point& a, const point& b) {
        return {a.x - b.x, a.y - b.y};
    }
    void rotate90() {
        ll px = x;
        x = -y;
        y = x;
    }
};

int n;

int row_len(int i) {
    if (i < n) {
        return n + i;
    } else {
        return 3 * n - i - 2;
    }
}

int row_start(int i) {
    if (i < n) {
        return 0;
    } else {
        return i - n + 1;
    }
}

void print_hex(const vector<vector<int>>& a) {

    for (int i = 0; i < a.size(); ++i) {
        int r_sz = row_len(i);
        int r = row_start(i);
//        for (int j = 0; j < r; ++j) {
//            cout << "  ";
//        }
        for (int j = 0; j < r_sz; ++j) {
            cout << a[i][j + r] << ' ';
        }
        cout << '\n';
    }
}


vector<vector<int>> rotate60(const vector<vector<int>>&  a) {
    vector<vector<int>> b(n * 2 - 1, vector<int> (n * 2 - 1));
    for (int i = 0; i < a.size(); ++i) {
        int r_sz = row_len(i);
        int r_st = row_start(i);
        int r = r_st;
        int c = max(0, n - i - 1);
        for (int j = 0; j < r_sz; ++j) {
            b[r + j][c + j] = a[i][r_st + j];
        }
    }
    return b;
}

void solve() {
    cin >> n;
    vector<vector<int>> a(n * 2 - 1, vector<int> (n * 2 - 1));
    for (int i = 0; i < a.size(); ++i) {
        int r_sz = row_len(i);
        int r = row_start(i);
//        cerr << r_sz << ' ' << r << endl;
        for (int j = 0; j < r_sz; ++j) {
            cin >> a[i][j + r];
        }
    }
    int t_cnt = 0;
    int rt = 0;
    string s;
    cin >> s;
    for (char c : s) {
        if (c == 'T') {
            t_cnt ^= 1;
            rt = (6 - rt) % 6;
        } else if (c == 'L') {
            rt = (rt + 5) % 6;
        } else {
            rt = (rt + 1) % 6;
        }
    }
    if (t_cnt) {
        for (int i = 0; i < a.size(); ++i) {
            std::reverse(a[i].begin() + row_start(i), a[i].begin() + row_start(i) + row_len(i));
        }
    }
    for (int i = 0; i < rt; ++i) {
        a = rotate60(a);
    }
    print_hex(a);
}

signed main() {
#ifdef pskobx
    freopen("input", "r", stdin);
    freopen("out", "w", stdout);
#endif
#ifndef pskobx
    std::ios::sync_with_stdio(false);
    cin.tie(nullptr);
#endif

    int tests = 1;
//    cin >> tests;

    while (tests--) {
        solve();
//        cout << '\n';
    }
}

