from sys import stdin
from collections import deque
 
 
def istr(): return str(stdin.readline().strip())
 
 
def lstr(): return list(map(str, list(stdin.readline().strip())))
 
 
def iint(): return int(stdin.readline().strip())
 
 
def lint(): return list(map(int, stdin.readline().strip().split()))
 
 
def bint(): return list(map(int, list(stdin.readline().strip())))


class Hex:
    def __init__(self, n):
        self.hex_triangles = deque()
        self.special = False
        self.length = n

    def add(self, triangle):
        self.hex_triangles.append(triangle)
    
    def left(self):
        self.hex_triangles.append(self.hex_triangles.popleft())

    def right(self):
        self.hex_triangles.appendleft(self.hex_triangles.pop())
    
    def rotate(self):
        self.special = not self.special
        self.hex_triangles[1], self.hex_triangles[5] =  self.hex_triangles[5], self.hex_triangles[1]
        self.hex_triangles[2], self.hex_triangles[4] =  self.hex_triangles[4], self.hex_triangles[2]
    
    def make_rotation(self):
        for tre_idx in range(6):
            for i in range(self.length):
                self.hex_triangles[tre_idx][i] = self.hex_triangles[tre_idx][i][::-1]



# K
def sol():
    n = iint()
    hex = [lint() for i in range(2 * n - 1)]
    first = []
    hexClass = Hex(n)

    for i in range(n):
        first.append([])
        for j in range(i, n):
            first[-1].append(hex[i][j])

    hexClass.add(first)

    second = []
    for i in range(n):
        second.append([])
        for j in range(n - i):
            second[-1].append(hex[i + j][n - 1 + j])
    
    hexClass.add(second)
    
    third = []
    for i in range(n):
        third.append([])
        for j in range(n - i):
            third[-1].append(hex[n - 1 + j][2 * n - 2 - j - i])

    hexClass.add(third)

    fourth = []
    for i in range(n):
        fourth.append([])
        for j in range(n - i):
            fourth[-1].append(hex[2 * n - 2 - i][n - 1 - j])

    hexClass.add(fourth)

    fifth = []
    for i in range(n):
        fifth.append([])
        for j in range(n - i):
            fifth[-1].append(hex[2 * n - 2 - j - i][i])

    hexClass.add(fifth)

    sixth = []
    for i in range(n):
        sixth.append([])
        for j in range(n - i):
            sixth[-1].append(hex[n - 1 - j][i])

    hexClass.add(sixth)

    for i in istr():
        if i == "L":
            hexClass.left()
        elif i == "R":
            hexClass.right()
        else:
            hexClass.rotate()
    if hexClass.special:
        hexClass.make_rotation()

    ans = [[0 for i in range(2 * n - ((n - i % n) if i <= (n - 1) else (i + 2) - n))] for i in range(2 * n - 1)]
    
    for i in range(n):
        for j in range(n - i):
            ans[i][i + j] = hexClass.hex_triangles[0][i][j]

    for i in range(n):
        for j in range(n - i):
            ans[i + j][n + j - 1] = hexClass.hex_triangles[1][i][j]
        
    for i in range(n):
        for j in range(n - i):
            ans[n + j - 1][2 * n - 2 - j - i] = hexClass.hex_triangles[2][i][j]

    for i in range(n):
        for j in range(n - i):
            ans[2 * n - 2 - i][n - j - 1] = hexClass.hex_triangles[3][i][j]

    for i in range(n):
        for j in range(n - i):
            ans[2 * n - 2 - j - i][i] = hexClass.hex_triangles[4][i][j]

    for i in range(n):
        for j in range(n - i):
            ans[n - j - 1][i] = hexClass.hex_triangles[5][i][j]

    for i in ans:
        print(*i)


# ttt = iint()
ttt = 1
for __ in range(ttt):
    sol()