﻿#include <iostream>

const long long MOD = 1000000007;

long long power(long long base, long long exp, long long mod) {
    long long res = 1;
    base %= mod;
    while (exp > 0) {
        if (exp & 1) {res = (res * base) % mod;}
        base = (base * base) % mod;
        exp >>= 1;
    }
    return res;
}

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(nullptr);

    int t;
    std::cin >> t;

    while (t--) {
        long long p, m;
        std::cin >> p >> m;
        if (p == 1 && m == 1) {
            long long inv3 = power(3, MOD - 2, MOD);
            long long ans = (8 * inv3) % MOD;
            std::cout << ans << std::endl;
            continue;
        }
        long long numer = (2LL * p % MOD * ((p + m) % MOD) % MOD + p) % MOD;
        long long denom = (p + m) % MOD;
        long long idenom = power(denom, MOD - 2, MOD);
        long long ans = (numer * idenom) % MOD;

        std::cout << ans << std::endl;
    }

    return 0;
}

