#include <iostream>
#include <vector>

using namespace std;

const int MOD = 999983;
const int MUL = 618023;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, s;
    cin >> n >> s;

    vector<int> sequence(n);
    for (int i = 0; i < n; i++) {
        s = (int)((1LL * s * MUL + 1) % MOD);
        sequence[i] = s;
    }

    vector<bool> inV(MOD, false);
    vector<int> elements;
    elements.reserve(n);

    vector<int> pairCount(MOD, 0);
    int count = 0;

    for (int step = 0; step < n; step++) {
        int current = sequence[step];

        if (pairCount[current] % 2 == 0) {
            if (!inV[current]) {
                inV[current] = true;
                count++;

                for (int a : elements) {
                    int sum1 = a + current;
                    if (sum1 < MOD) pairCount[sum1]++;
                }
                int sum2 = current * 2;
                if (sum2 < MOD) pairCount[sum2]++;

                elements.push_back(current);
            }
        }
    }

    cout << count;
    return 0;
}