#include <iostream>
#include <vector>

using namespace std;

const int MOD = 999983;
const int MUL = 618023;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, s;
    cin >> n >> s;

    vector<int> sequence(n);
    for (int i = 0; i < n; i++) {
        s = (int)((1LL * s * MUL + 1) % MOD);
        sequence[i] = s;
    }

    vector<bool> inV(MOD, false);
    vector<int> elements;
    elements.reserve(n);

    vector<bool> inSequence(MOD, false);
    for (int x : sequence) {
        inSequence[x] = true;
    }

    int count = 0;

    for (int step = 0; step < n; step++) {
        int current = sequence[step];

        int pairCount = 0;

        for (int a : elements) {
            int b = current - a;
            if (b < 0 || b >= MOD) continue;
            if (b < a) continue;

            if (inV[b]) {
                pairCount++;
            }
        }

        if (pairCount % 2 == 0) {
            if (!inV[current]) {
                inV[current] = true;
                elements.push_back(current);
                count++;
            }
        }
    }

    cout << count;
    return 0;
}