#include <iostream>
#include <vector>
#include <cstdint>
#include <climits>

using namespace std;

static const int MOD = 999983;
static const int MUL = 618023;

struct BitBlocks {
    int nbits, nblocks;
    vector<uint64_t> b;
    BitBlocks(int n = 0) { reset(n); }
    void reset(int n) {
        nbits = n;
        nblocks = (n + 63) >> 6;
        b.assign(nblocks, 0);
    }
    inline void set1(int i) { b[i >> 6] |= (1ULL << (i & 63)); }
    inline bool get(int i) const { return (b[i >> 6] >> (i & 63)) & 1ULL; }
    inline void xor_bit(int i) { b[i >> 6] ^= (1ULL << (i & 63)); }
    inline void clamp_last() {
        int rem = nbits & 63;
        if (rem) b.back() &= ((1ULL << rem) - 1ULL);
    }
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, s0;
    if (!(cin >> n >> s0)) return 0;

    vector<int> seq(n);
    int s = s0;
    for (int i = 0; i < n; ++i) {
        s = (int)((1LL * s * MUL + 1) % MOD);
        seq[i] = s;
    }

    BitBlocks query(MOD);
    for (int x : seq) query.set1(x);

    BitBlocks flip(MOD), present(MOD);
    vector<int> elems; elems.reserve(n);

    auto update_flip_blockwise = [&](int shift) {
        const int w = 64;
        int sw = shift >> 6;
        int sb = shift & 63;

        const int nb = present.nblocks;
        for (int i = 0; i < nb; ++i) {
            uint64_t pv = present.b[i];
            if (!pv) continue;

            int j = i + sw;
            if (j >= query.nblocks) break;

            uint64_t qlow = query.b[j] >> sb;
            uint64_t qhigh = 0;
            if (sb && j + 1 < query.nblocks) {
                qhigh = query.b[j + 1] << (w - sb);
            }
            uint64_t qmask = qlow | qhigh;

            uint64_t common = pv & qmask;
            if (!common) continue;

            flip.b[j] ^= (sb ? (common << sb) : common);
            if (sb && j + 1 < flip.nblocks)
                flip.b[j + 1] ^= (common >> (w - sb));
        }
        flip.clamp_last();
        };

    const int SMALL_THRESHOLD = 4096;

    int answer = 0;

    for (int step = 0; step < n; ++step) {
        int cur = seq[step];

        int eq = ((cur & 1) == 0 && present.get(cur >> 1)) ? 1 : 0;

        int parity = eq ^ (flip.get(cur) ? 1 : 0);
        if (parity == 0) {
            if (!present.get(cur)) {
                if ((int)elems.size() < SMALL_THRESHOLD) {
                    for (int a : elems) {
                        int y = cur + a;
                        if (y < MOD && query.get(y)) flip.xor_bit(y);
                    }
                }
                else {
                    update_flip_blockwise(cur);
                }
                present.set1(cur);
                elems.push_back(cur);
                ++answer;
            }
        }
    }

    cout << answer;
    return 0;
}
