#include <iostream>
#include <string>
#include <vector>
#include <algorithm>

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    cin >> t;

    string letters = "ABCDEFG";

    while (t--) {
        string s;
        cin >> s;

        if (s.empty()) {
            cout << "Yes\n";
            continue;
        }

        vector<bool> possible(52, false);


        for (int i = 0; i < 52; ++i) {
            if (letters[i % 7] == s[0]) {
                possible[i] = true;
            }
        }


        for (int i = 1; i < s.size(); ++i) {
            vector<bool> next_possible(52, false);
            char target = s[i];

            for (int pos = 0; pos < 52; ++pos) {
                if (!possible[pos]) continue;

                for (int next_pos = max(0, pos - 3); next_pos <= min(51, pos + 3); ++next_pos) {
                    if (letters[next_pos % 7] == target) {
                        next_possible[next_pos] = true;
                    }
                }
            }

            possible = move(next_possible);
        }

        bool found = false;
        for (bool p : possible) {
            if (p) {
                found = true;
                break;
            }
        }

        cout << (found ? "Yes" : "No") << '\n';
    }

    return 0;
}