import java.util.*;

public class Main {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        int t = Integer.parseInt(sc.nextLine());
        String[] melodies = new String[t];
        for (int i = 0; i < t; i++) {
            melodies[i] = sc.nextLine().trim();
        }
        Map<Character, int[]> noteMap = new HashMap<>();
        for (char c = 'A'; c <= 'G'; c++) {
            List<Integer> positions = new ArrayList<>();
            for (int p = 0; p < 52; p++) {
                if ((p % 7) + 'A' == c) positions.add(p);
            }
            int[] arr = positions.stream().mapToInt(Integer::intValue).toArray();
            noteMap.put(c, arr);
        }
        List<String> answers = new ArrayList<>();
        for (String s : melodies) {
            Set<Integer> curr = new HashSet<>();
            for (int pos : noteMap.get(s.charAt(0))) {
                curr.add(pos);
            }
            boolean possible = true;
            for (int i = 1; i < s.length(); i++) {
                Set<Integer> next = new HashSet<>();
                for (int pos : noteMap.get(s.charAt(i))) {
                    for (int c : curr) {
                        if (Math.abs(pos - c) <= 3) {
                            next.add(pos);
                            break;
                        }
                    }
                }
                if (next.isEmpty()) {
                    possible = false;
                    break;
                }
                curr = next;
            }
            answers.add(possible ? "Yes" : "No");
        }
        for (String ans : answers) {
            System.out.println(ans);
        }
    }
}
