#include <iostream>
#include <vector>
#include <numeric>
using namespace std;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    long long operation_type;
    if (!(cin >> operation_type)) return 0;

    int element_count;
    cin >> element_count;

    vector<long long> sequence(element_count);
    for (int i = 0; i < element_count; i++) {
        cin >> sequence[i];
    }

    if (operation_type == 0) {
        long long hash_value = 0;
        for (int i = 0; i < element_count; i++) {
            hash_value = (hash_value * 31 + sequence[i]) % element_count;
        }
        int selected_index = hash_value + 1;
        cout << selected_index << '\n';
    } else {
        int position = (int)operation_type;
        int total_elements = element_count + 1;
        
        long long visible_sum = accumulate(sequence.begin(), sequence.end(), 0LL);
        
        long long complete_sum = (long long)total_elements * (total_elements + 1) / 2;
        
        long long missing_value = complete_sum - visible_sum;
        
        long long final_result = ((position - 1) * total_elements + missing_value) % total_elements;
        if (final_result == 0) final_result = total_elements;
        
        cout << final_result << '\n';
    }
    
    return 0;
}