#include <bits/stdc++.h>
using namespace std;

const long long MOD = 1000000007;

vector<long long> precompute_inverses(int n) {
    vector<long long> inv(n + 1);
    inv[1] = 1;
    for (int i = 2; i <= n; ++i)
        inv[i] = MOD - (MOD / i) * inv[MOD % i] % MOD;
    return inv;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    cin >> t;

    vector<pair<int, int>> tests(t);
    int max_p = 0;

    for (int i = 0; i < t; ++i) {
        cin >> tests[i].first >> tests[i].second;
        max_p = max(max_p, tests[i].first);
    }

    int max_inv_needed = max(2 * max_p + 1, max_p);
    vector<long long> inv = precompute_inverses(max_inv_needed);

    for (auto [p, m] : tests) {
        long long comb = 1;  // C(p, 0)
        long long total = 0;

        for (int s = 0; s <= p; ++s) {
            long long inv_denom = inv[1 + 2 * s];
            long long term = comb * inv_denom % MOD;
            if (s % 2 == 1)
                total = (total - term + MOD) % MOD;
            else
                total = (total + term) % MOD;

            if (s < p) {
                comb = comb * (p - s) % MOD;
                comb = comb * inv[s + 1] % MOD;
            }
        }

        long long coef = (1 + 2LL * p + m) % MOD;
        long long ans = coef * total % MOD;

        cout << ans << '\n';
    }

    return 0;
}
