#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>

using point = std::pair<int, int>;

double getDistance(int a, int b, int c1, int c2) {
    return abs(c1 - c2) / sqrt(a * a + b * b);
}

int main() {
    int n;
    std::cin >> n;
    std::vector<point> points(n);
    
    for(int i = 0; i < n; i++) {
        std::cin >> points[i].first >> points[i].second;
    }
    
    int best_a = 0, best_b = 0, best_c1 = 0, best_c2 = 0;
    double max_distance = 0;
    
    for(int i = 0; i < n; i++) {
        for(int j = 0; j < n; j++) {
            if(i == j) continue;
            
            int a = points[j].second - points[i].second;
            int b = points[i].first - points[j].first;
            
            for(int k = 0; k < n; k++) {
                int c1 = -(a * points[k].first + b * points[k].second);
                
                for(int l = 0; l < n; l++) {
                    int c2 = -(a * points[l].first + b * points[l].second);
                    if(c1 == c2) continue;
                    
                    if(c1 > c2) {
                        std::swap(c1, c2);
                    }
                    
                    bool valid = true;
                    for(const point& p : points) {
                        int val = a * p.first + b * p.second + c1;
                        int val2 = a * p.first + b * p.second + c2;
                        if(val * val2 > 0) {
                            valid = false;
                            break;
                        }
                    }
                    
                    if(valid) {
                        double dist = getDistance(a, b, c1, c2);
                        if(dist > max_distance) {
                            max_distance = dist;
                            best_a = a;
                            best_b = b;
                            best_c1 = c1;
                            best_c2 = c2;
                        }
                    }
                }
            }
        }
    }
    
    std::cout << best_a << " " << best_b << " " << best_c1 << '\n';
    std::cout << best_a << " " << best_b << " " << best_c2 << '\n';
    
    return 0;
}