#include <bits/stdc++.h>
using namespace std;

const long long MOD = 1000000007;

long long mod_pow(long long base, long long exp) {
    long long result = 1;
    base %= MOD;
    while (exp > 0) {
        if (exp & 1) result = result * base % MOD;
        base = base * base % MOD;
        exp >>= 1;
    }
    return result;
}

long long mod_inv(long long a) {
    return mod_pow(a, MOD - 2);
}

long long gcd_func(long long a, long long b) {
    while (b) {
        long long t = b;
        b = a % b;
        a = t;
    }
    return a;
}

int p, m, total;
map<pair<int, int>, pair<long long, long long>> dp;

pair<long long, long long> solve(int i, int j) {
    auto key = make_pair(i, j);
    if (dp.count(key)) return dp[key];

    int remain = total - i - j;
    if (remain == 0) return dp[key] = {0, 1};

    int pair_cnt = 2 * p - 2 * i;
    int single_cnt = m - j;

    long long num = 1, den = 1;

    if (pair_cnt > 0) {
        auto [n1, d1] = solve(i + 1, j);
        num = num * remain * d1 + (long long)pair_cnt * n1 * den;
        den = den * remain * d1;

        long long g = gcd_func(num, den);
        num /= g;
        den /= g;
    }

    if (single_cnt > 0) {
        auto [n2, d2] = solve(i, j + 1);
        num = num * remain * d2 + (long long)single_cnt * n2 * den;
        den = den * remain * d2;

        long long g = gcd_func(num, den);
        num /= g;
        den /= g;
    }

    return dp[key] = {num, den};
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int t;
    cin >> t;

    while (t--) {
        cin >> p >> m;
        total = 2 * p + m;
        dp.clear();

        auto [num, den] = solve(0, 0);
        long long ans = (num % MOD * mod_inv(den % MOD)) % MOD;
        cout << ans << "\n";
    }

    return 0;
}
