﻿#include <iostream>
#include <vector>
#include <cmath>

const long long MOD = 998244353;
const long long G = 3;

long long power(long long base, long long exp) {
    long long res = 1;
    base %= MOD;
    while (exp > 0) {
        if (exp % 2 == 1) res = (res * base) % MOD;
        base = (base * base) % MOD;
        exp /= 2;
    }
    return res;
}

long long modInverse(long long n) {
    return power(n, MOD - 2);
}

void ntt(std::vector<long long>& a, bool inv) {
    int n = a.size();
    for (int i = 1, j = 0; i < n; i++) {
        int bit = n >> 1;
        for (; j & bit; bit >>= 1)
            j ^= bit;
        j ^= bit;
        if (i < j)
            std::swap(a[i], a[j]);
    }

    for (int len = 2; len <= n; len <<= 1) {
        long long wlen = power(G, (MOD - 1) / len);
        if (inv)
            wlen = modInverse(wlen);
        for (int i = 0; i < n; i += len) {
            long long w = 1;
            for (int j = 0; j < len / 2; j++) {
                long long u = a[i + j];
                long long v = (a[i + j + len / 2] * w) % MOD;
                a[i + j] = (u + v) % MOD;
                a[i + j + len / 2] = (u - v + MOD) % MOD;
                w = (w * wlen) % MOD;
            }
        }
    }
    if (inv) {
        long long n_inv = modInverse(n);
        for (long long& x : a)
            x = (x * n_inv) % MOD;
    }
}

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);

    int n;
    long long s_ll;
    std::cin >> n >> s_ll;

    const long long A = 618023LL;
    const long long C = 1LL;
    const int M = 999983;

    const int N = 1 << 20;
    const int NTT_SIZE = 1 << 21;

    int BLOCK_SIZE = 4500;

    std::vector<bool> V_exists(M, false);
    std::vector<int> V_elements;
    V_elements.reserve(n);

    std::vector<long long> P_V0(NTT_SIZE);
    std::vector<long long> C_V0(NTT_SIZE);
    std::vector<int> delta_elements;
    delta_elements.reserve(BLOCK_SIZE);
    std::vector<bool> delta_exists(M, false);

    int current_block_size = 0;
    int final_size = 0;

    long long inv_2 = (MOD + 1) / 2;

    for (int i = 0; i < n; ++i) {
        if (current_block_size == 0) {
            std::fill(P_V0.begin(), P_V0.end(), 0);
            for (int v : V_elements) {
                P_V0[v] = 1;
            }

            ntt(P_V0, false);

            for (int j = 0; j < NTT_SIZE; ++j) {
                C_V0[j] = (P_V0[j] * P_V0[j]) % MOD;
            }

            ntt(C_V0, true);

            delta_elements.clear();
            std::fill(delta_exists.begin(), delta_exists.end(), false);
        }

        s_ll = (s_ll * A + C) % M;
        int s = (int)s_ll;
        long long count_C0 = C_V0[s];

        long long count_V0_Delta = 0;
        for (int b : delta_elements) {
            int a = s - b;
            if (a >= 0 && a < M && V_exists[a] && !delta_exists[a]) {
                count_V0_Delta++;
            }
        }

        long long count_Delta_Delta = 0;
        for (int b : delta_elements) {
            int a = s - b;
            if (a >= 0 && a < M && delta_exists[a]) {
                count_Delta_Delta++;
            }
        }
        long long C_total = (count_C0 + 2 * count_V0_Delta + count_Delta_Delta) % MOD;
        if (C_total < 0) C_total += MOD;

        long long pair_count;

        if (s % 2 == 0 && V_exists[s / 2]) {
            pair_count = (C_total + 1) * inv_2 % MOD;
        }
        else {
            pair_count = (C_total * inv_2) % MOD;
        }

        if (pair_count % 2 == 0) {
            if (!V_exists[s]) {
                V_exists[s] = true;
                V_elements.push_back(s);
                final_size++;

                delta_exists[s] = true;
                delta_elements.push_back(s);
            }
        }

        current_block_size++;
        if (current_block_size == BLOCK_SIZE) {
            current_block_size = 0;
        }
    }

    std::cout << final_size << "\n";
    return 0;
}