﻿#include <iostream>
#include <vector>
#include <array>
#include <algorithm>
#include <cstdint>

using namespace std;

using ull = uint64_t;

const int MOD = 999983;
const int WORD_BITS = 64;
const int NUM_WORDS = (MOD + WORD_BITS - 1) / WORD_BITS;

ull reverse_bits(ull x) {
    x = ((x & 0x5555555555555555ULL) << 1) | ((x >> 1) & 0x5555555555555555ULL);
    x = ((x & 0x3333333333333333ULL) << 2) | ((x >> 2) & 0x3333333333333333ULL);
    x = ((x & 0x0F0F0F0F0F0F0F0FULL) << 4) | ((x >> 4) & 0x0F0F0F0F0F0F0F0FULL);
    x = ((x & 0x00FF00FF00FF00FFULL) << 8) | ((x >> 8) & 0x00FF00FF00FF00FFULL);
    x = ((x & 0x0000FFFF0000FFFFULL) << 16) | ((x >> 16) & 0x0000FFFF0000FFFFULL);
    x = (x << 32) | (x >> 32);
    return x;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    long long n;
    long long s;
    cin >> n >> s;

    const long long mult = 618023;

    // Compute the period p
    long long current = (s * mult + 1) % MOD;
    long long first = current;
    long long p = 0;
    do {
        current = (current * mult + 1) % MOD;
        p++;
    } while (current != first && p <= MOD);

    array<ull, NUM_WORDS> exists_data{};
    auto exists_test = [&exists_data](int i) -> bool {
        return (exists_data[i / WORD_BITS] & (1ULL << (i % WORD_BITS))) != 0;
        };
    auto exists_set = [&exists_data](int i) {
        exists_data[i / WORD_BITS] |= (1ULL << (i % WORD_BITS));
        };

    vector<int> V_list;
    V_list.reserve(MOD);

    int v_size = 0;

    long long i = 0;
    long long last_add = -1;

    while (i < n) {
        s = (s * mult + 1) % MOD;
        i++;
        if (i > n) break;
        const int s_int = static_cast<int>(s);
        if (exists_test(s_int)) {
            if (i - last_add > p) break;
            continue;
        }
        const int s_half = s_int / 2;
        int count_parity = 0;
        if (v_size < s_half) {
            const int* current_v = V_list.data();
            const int* end_v = V_list.data() + v_size;
            while (current_v != end_v) {
                const int a = *current_v++;
                if (a > s_half) continue;
                if (exists_test(s_int - a)) count_parity ^= 1;
            }
        }
        else {
            const int num_words = (s_half + WORD_BITS - 1) / WORD_BITS;
            for (int k = 0; k < num_words; ++k) {
                int low_base = k * WORD_BITS;
                int num_bits = min(WORD_BITS, s_half - low_base);
                ull low_word = exists_data[k];
                low_word &= (1ULL << num_bits) - 1ULL;

                int h_start = s_int - low_base - (num_bits - 1);
                int high_word_idx = h_start / WORD_BITS;
                int high_offset = h_start % WORD_BITS;

                ull concat;
                if (high_offset == 0) {
                    concat = (high_word_idx < NUM_WORDS) ? exists_data[high_word_idx] : 0ULL;
                }
                else {
                    ull high_word1 = (high_word_idx < NUM_WORDS) ? exists_data[high_word_idx] : 0ULL;
                    ull high_word2 = (high_word_idx + 1 < NUM_WORDS) ? exists_data[high_word_idx + 1] : 0ULL;
                    concat = (high_word1 >> high_offset) | (high_word2 << (WORD_BITS - high_offset));
                }

                concat &= (1ULL << num_bits) - 1ULL;
                ull high_reversed = reverse_bits(concat);
                high_reversed >>= (WORD_BITS - num_bits);
                ull anded = low_word & high_reversed;
                count_parity ^= __builtin_parityll(anded);
            }
            if ((s_int & 1) == 0) {
                if (exists_test(s_half)) {
                    count_parity ^= 1;
                }
            }
        }

        if (count_parity == 0) {
            exists_set(s_int);
            V_list.push_back(s_int);
            v_size++;
            last_add = i;
        }
        if (i - last_add > p) break;
    }

    cout << v_size << "\n";

    return 0;
}