#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

const int MOD = 1e9 + 7;
const int MAXN = 3000005; //   n <= 2p+m <= 3e6

int fact[MAXN], invfact[MAXN];

int modpow(int a, int e) {
    int res = 1;
    while (e) {
        if (e & 1) res = 1LL * res * a % MOD;
        a = 1LL * a * a % MOD;
        e >>= 1;
    }
    return res;
}

void precompute() {
    fact[0] = 1;
    for (int i = 1; i < MAXN; i++)
        fact[i] = 1LL * fact[i - 1] * i % MOD;
    invfact[MAXN - 1] = modpow(fact[MAXN - 1], MOD - 2);
    for (int i = MAXN - 2; i >= 0; i--)
        invfact[i] = 1LL * invfact[i + 1] * (i + 1) % MOD;
}

int nCr(int n, int r) {
    if (r < 0 || r > n) return 0;
    return 1LL * fact[n] * invfact[r] % MOD * invfact[n - r] % MOD;
}

int solve(int p, int m) {
    int n = 2 * p + m;
    int ans = 0;
    for (int k = 0; k <= p + m; k++) {
        int ways = 0;
        for (int r = 0; r <= min(p, k); r++) {
            if (k - r > m) continue;
            ways = (ways + 1LL * nCr(p, r) * modpow(2, r) % MOD * nCr(m, k - r)) % MOD;
        }
        //  :    
        int denominator = nCr(n, k);
        int inv_denom = modpow(denominator, MOD - 2);
        ans = (ans + 1LL * ways * inv_denom) % MOD;
    }
    return ans;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    precompute();
    int t;
    cin >> t;
    while (t--) {
        int p, m;
        cin >> p >> m;
        cout << solve(p, m) << "\n";
    }
    return 0;
}