import math

def main():
    n = int(input())
    points = []
    for _ in range(n):
        x, y = map(int, input().split())
        points.append((x, y))
    
    max_dist = -1
    best_a, best_b = 0, 0
    best_c1, best_c2 = 0, 0
    
    for i in range(n):
        for j in range(i + 1, n):
            x1, y1 = points[i]
            x2, y2 = points[j]
            
            a = x2 - x1
            b = y2 - y1
            
            if a == 0 and b == 0:
                continue
                
            min_proj = float('inf')
            max_proj = float('-inf')
            
            for x, y in points:
                proj = a * x + b * y
                
                if proj < min_proj:
                    min_proj = proj
                if proj > max_proj:
                    max_proj = proj
            
            denominator = math.sqrt(a * a + b * b)
            dist = (max_proj - min_proj) / denominator
                
            if dist > max_dist:
                max_dist = dist
                best_a, best_b = a, b
                best_c1 = -min_proj
                best_c2 = -max_proj
    
    print(f"{best_a} {best_b} {best_c1}")
    print(f"{best_a} {best_b} {best_c2}")

if __name__ == "__main__":
    main()
