def pianist(s):
    def octave_range(ch):
        if ch in "ABC":
            return (1, 8)
        else:
            return (1, 7)
    
    def position(ch, octave):
        offset = {'A':1, 'B':2, 'C':3, 'D':4, 'E':5, 'F':6, 'G':7}
        return (octave - 1) * 7 + offset[ch]
    
    min_oct, max_oct = octave_range(s[0])
    
    for i in range(1, len(s)):
        prev_ch = s[i-1]
        curr_ch = s[i]
        curr_min, curr_max = octave_range(curr_ch)
        
        new_min = None
        new_max = None
        
        for curr_oct in range(curr_min, curr_max + 1):
            for prev_oct in range(min_oct, max_oct + 1):
                if abs(position(curr_ch, curr_oct) - position(prev_ch, prev_oct)) <= 3:
                    if new_min is None or curr_oct < new_min:
                        new_min = curr_oct
                    if new_max is None or curr_oct > new_max:
                        new_max = curr_oct
                    break
        
        if new_min is None:
            return "No"
        
        min_oct, max_oct = new_min, new_max
    
    return "Yes"

t = int(input())
for _ in range(t):
    melody = input().strip()
    print(pianist(melody))
