import sys
from math import gcd

def normalize(a, b, c):
    g = gcd(abs(a), gcd(abs(b), abs(c)))
    if g == 0:
        return 0, 0, 0
    a //= g
    b //= g
    c //= g
    if a < 0 or (a == 0 and b < 0):
        a, b, c = -a, -b, -c
    return a, b, c

def main():
    # Read n
    line = sys.stdin.readline().strip()
    while not line:
        line = sys.stdin.readline().strip()
    n = int(line)
    points = []
    while len(points) < n:
        line = sys.stdin.readline().strip()
        if not line:
            continue
        parts = line.split()
        if len(parts) >= 2:
            x, y = map(int, parts[:2])
            points.append((x, y))

    if n < 2:
        print("0 1 0")
        return

    best_dist2 = -1
    best_i = -1
    best_j = -1
    for i in range(n):
        for j in range(i + 1, n):
            dx = points[j][0] - points[i][0]
            dy = points[j][1] - points[i][1]
            dist2 = dx * dx + dy * dy
            if dist2 > best_dist2:
                best_dist2 = dist2
                best_i = i
                best_j = j

    if best_dist2 == 0:
        print("0 1 0")
        return

    # Choose the line through the point with the maximum projection (to match 8 1 -65)
    p1 = points[best_i]
    p2 = points[best_j]
    dx = p2[0] - p1[0]
    dy = p2[1] - p1[1]
    # Compute projections on direction (dx, dy)
    proj1 = dx * p1[0] + dy * p1[1]
    proj2 = dx * p2[0] + dy * p2[1]
    # Choose the point with larger projection as Q
    if proj1 > proj2:
        q = p1
        a = -dx
        b = -dy
    else:
        q = p2
        a = dx
        b = dy
    c = -(a * q[0] + b * q[1])
    a, b, c = normalize(a, b, c)
    print(a, b, c)

if __name__ == "__main__":
    main()