import java.util.Scanner;

public class Main {
    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        int t = scanner.nextInt();
        scanner.nextLine();

        String piano = "ABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGAB";

        for (int i = 0; i < t; i++) {
            String melody = scanner.nextLine().trim();
            if (melody.isEmpty()) {
                System.out.println("Yes");
                continue;
            }
            System.out.println(canPlay(melody, piano) ? "Yes" : "No");
        }
        scanner.close();
    }

    private static boolean canPlay(String melody, String piano) {
        char first = melody.charAt(0);

        for (int start = 0; start < piano.length(); start++) {
            if (piano.charAt(start) == first) {
                if (checkPath(melody, piano, start)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean checkPath(String melody, String piano, int pos) {
        int current = pos;
        for (int i = 1; i < melody.length(); i++) {
            char target = melody.charAt(i);
            boolean found = false;

            for (int d = -3; d <= 3; d++) {
                int next = current + d;
                if (next >= 0 && next < piano.length() && piano.charAt(next) == target) {
                    current = next;
                    found = true;
                    break;
                }
            }
            if (!found) {
                return false;
            }
        }
        return true;
    }
}