def is_valid_sequence(notes):
    white_notes = ['A', 'B', 'C', 'D', 'E', 'F', 'G']
    
    neighbors = {
        'A': ['G', 'B'],
        'B': ['A', 'C'],
        'C': ['B', 'D'],
        'D': ['C', 'E'],
        'E': ['D', 'F'],
        'F': ['E', 'G'],
        'G': ['F', 'A']
    }
    
    for i in range(len(notes) - 1):
        current_note = notes[i]
        next_note = notes[i + 1]
        
        if next_note not in neighbors[current_note]:
            return "NO"
    
    return "YES"

def main():
    n = int(input().strip())
    results = []
    
    for _ in range(n):
        sequence = input().strip()
        results.append(is_valid_sequence(sequence))
    
    for result in results:
        print(result)

if __name__ == "__main__":
    main()
