// Author: Ivan Kazmenko (gassa@mail.ru)
// Validator for problem "twosum"
module validate;
import std.exception;
import testlib;

immutable int minN =       1;
immutable int maxN = 200_000;
immutable int minS =       0;
immutable int maxS = 999_982;
immutable int notS = 742_681;

void main (string [] args)
{
	initTestlib !(TestlibRole.validator) (args);

	auto n = inFile.read !(int) (minN, maxN);
	inFile.skip (" ");
	auto s = inFile.read !(int) (minS, maxS);
	enforce (s != notS);
	inFile.skip ("\n");

	inFile.checkEof ();
}
