#include <bits/stdc++.h>
using namespace std;

const int inf = int(1e9);

struct segtree
{
    int tsz;
    vector<pair<int, int>> val;
    vector<int> to_add;

    segtree (const vector<int> &a)
    {
        tsz = 1;
        while (tsz < int(a.size()))
            tsz *= 2;

        val.assign(2 * tsz, pair<int, int>(inf, -1));
        to_add.assign(2 * tsz, 0);

        for (int i = 0; i < int(a.size()); i++)
            val[i + tsz] = pair<int, int>(a[i], i);

        for (int i = tsz - 1; i >= 1; i--)
            val[i] = min(val[2 * i], val[2 * i + 1]);
    }

    pair<int, int> getmin ()
    {
        return val[1];
    }

    void apply (const int v, const int delta)
    {
        to_add[v] += delta;
        val[v].first += delta;
    }

    void push (const int v)
    {
        if (to_add[v] != 0)
        {
            apply(2 * v + 0, to_add[v]);
            apply(2 * v + 1, to_add[v]);
            to_add[v] = 0;
        }
    }

    void go_incr (const int v, const int tl, const int tr,
                  const int l, const int r, const int delta)
    {
        if (r <= tl || tr <= l)
            return;

        if (l <= tl && tr <= r)
        {
            apply(v, delta);
            return;
        }

        push(v);
        const int tm = (tl + tr) / 2;
        go_incr(2 * v + 0, tl, tm, l, r, delta);
        go_incr(2 * v + 1, tm, tr, l, r, delta);
        val[v] = min(val[2 * v], val[2 * v + 1]);
    }

    void incr_seg (const int l, const int r, const int delta)
    {
        assert(0 <= l && l <= r && r <= tsz);
        if (delta == 0 || l == r)
            return;

        go_incr(1, 0, tsz, l, r, delta);
    }
};

int main()
{
    int n;
    cin >> n;

    vector<int> a(n);
    for (auto &it : a)
        cin >> it;

    vector<int> places;
    segtree info(a);

    for (int iter = 0; iter < n; iter++)
    {
        const auto [ai, i] = info.getmin();
        assert(ai == 0);
        assert(0 <= i && i < n);
        places.push_back(i);

        info.incr_seg(0, i, -1);
        info.incr_seg(i, i + 1, inf);
    }

    reverse(places.begin(), places.end());
    for (int i = 0; i < n; i++)
        cout << places[i] + 1 << " \n"[i + 1 == n];
}
