#include <iostream>

int64_t decipher(const char c) {
    return c - 'A';
}

int64_t divide_down_by_7(const int64_t n) {
    if (n >= 0)
        return n / 7;
    if (n == -1)
        return -1;
    return (n + 1) / 7 - 1;
}

bool find_ans(const std::string& score) {
    const int64_t LOW = 2, HIGH = 53;
    int64_t left = 1e9, right = -1e9, last = 3;
    for (char c : score) {
        last += (decipher(c) - last % 7 + 10) % 7 - 3;
        left = std::min(left, last);
        right = std::max(right, last);
        if (right - divide_down_by_7(left - LOW) * 7 > HIGH)
            return false;
    }
    return true;
}

bool solve_test([[maybe_unused]] size_t test_index) {
    std::string score;
    if (!(std::cin >> score))
        return false;
    bool ans = find_ans(score);
    std::cout << (ans ? "YES" : "NO") << '\n';
    return true;
}

void solve_tests() {
    size_t t;
    std::cin >> t;
    for (size_t i = 0; i < t; i++)
        if (!solve_test(i))
            return;
}

int main() {
    std::ios::sync_with_stdio(false);
    std::cin.tie(nullptr);
    solve_tests();
}
