#include <bits/stdc++.h>
using namespace std;

using ll = long long;

struct point
{
    int x, y;

    point () : x(0), y(0) {}
    point (const int x_, const int y_) : x(x_), y(y_) {}

    point operator - (const point &o) const
    {
        return point(x - o.x, y - o.y);
    }

    ll sqlen() const
    {
        return ll(x) * x + ll(y) * y;
    }

    int operator * (const point &o) const
    {
        return x * o.x + y * o.y;
    }
};

int main()
{
    int n;
    cin >> n;

    vector<point> pts(n);
    for (int i = 0; i < n; i++)
        cin >> pts[i].x >> pts[i].y;

    vector<point> when(2);
    ll best = -1;

    for (int i = 0; i < n; i++)
    for (int j = 0; j < i; j++)
    {
        const ll cur = (pts[i] - pts[j]).sqlen();

        bool ok = true;
        for (int k = 0; k < n && ok; k++)
        if ((pts[k] - pts[i]) * (pts[j] - pts[i]) < 0 ||
            (pts[k] - pts[j]) * (pts[i] - pts[j]) < 0)
            ok = false;

        if (ok && best < cur)
        {
            best = cur;
            when[0] = pts[i];
            when[1] = pts[j];
        }
    }


    vector<vector<int>> borders(2, vector<int>(3));
    for (int i = 0; i < 2; i++)
    {
        borders[i][0] = (when[1] - when[0]).x;
        borders[i][1] = (when[1] - when[0]).y;
        borders[i][2] = -(borders[i][0] * when[i].x + borders[i][1] * when[i].y);
    }

    for (auto &it : borders[0])
        it *= -2;
    for (auto &it : borders[1])
        it *= +5;

    for (int i = 0; i < 2; i++)
    {
        for (int j = 0; j < 3; j++)
            cout << borders[i][j] << " \n"[j + 1 == 3];
    }
}
