#include <bits/stdc++.h>
using namespace std;

using Num = long long;
//    
struct Point {
    Num x, y;
};

//     (  Ax + By + C = 0)
struct Line {
    Num A, B, C;
};

//     
double distance(const Point &p1, const Point &p2) {
    return hypot(p1.x - p2.x, p1.y - p2.y); //    hypot   
}

//   ,    
Line make_line(Point p1, Point p2) {
    Num A = p2.y - p1.y;
    Num B = p1.x - p2.x;
    Num C = A*p1.x + B*p1.y;
    return {A, B, -C}; //       C
}

//   ,       
Line perpendic_line(Line l, Point p) {
    Num A_perp = -l.B;
    Num B_perp = l.A;
    Num C_perp = -(A_perp * p.x + B_perp * p.y);
    return {A_perp, B_perp, C_perp};
}

int main() {
    int n;
    cin >> n;

    //   
    vector<Point> points(n);
    for(int i = 0; i < n; ++i) {
        cin >> points[i].x >> points[i].y;
    }

    //    
    double max_dist = 0;
    int idx1 = 0, idx2 = 0;
    for(int i = 0; i < n; ++i) {
        for(int j = i+1; j < n; ++j) {
            double curr_dist = distance(points[i], points[j]);
            if(curr_dist > max_dist) {
                max_dist = curr_dist;
                idx1 = i;
                idx2 = j;
            }
        }
    }

    //   ,     
    Line first_line = make_line(points[idx1], points[idx2]);

    //   ,     
    Line second_line = perpendic_line(first_line, points[idx1]); //   
    Line third_line = perpendic_line(first_line, points[idx2]);  //   

   /* cout << fixed << setprecision(0);
    cout << "  (  ): " << first_line.A << "*x + " << first_line.B << "*y + " << first_line.C << " = 0\n";
    cout << "  ( ,   ): " << second_line.A << "*x + " << second_line.B << "*y + " << second_line.C << " = 0\n";
    cout << "  ( ,   ): " << third_line.A << "*x + " << third_line.B << "*y + " << third_line.C << " = 0\n";
*/
cout << second_line.A <<" "<<second_line.B <<" "<< second_line.C<<'\n';
cout << third_line.A <<" "<< third_line.B <<" "<< third_line.C<<'\n';
    return 0;
}
