/**
 * Validator for problem Широкая Полоса.
 */

#include "testlib.h"

using namespace std;

constexpr int N = 1000;
constexpr int MAXC = 10000;

int main(int argc, char* argv[]) {
  registerValidation(argc, argv);
  const int n = inf.readInt(2, N, "number of points");
  inf.readEoln();
  set<pair<int, int>> s;
  for (int i = 0; i < n; ++i) {
    auto x = inf.readInt(0, MAXC, "x[]");
    inf.readSpace();
    auto y = inf.readInt(0, MAXC, "y[]");
    inf.readEoln();
    ensuref(!s.contains({x, y}), "duplicate point: ", x, ", ", y);
    s.insert({x, y});
  }
  inf.readEof();
  return 0;
}
