#include <iostream>
#include <vector>
#include <string>
#include <sstream>
#include <iomanip>
#include <cassert>

using namespace std;

vector<vector<int>> rotate_transform(const vector<vector<int>>& a, int n) {
    int m = n - 1;
    int size = n + m;
    vector<vector<int>> b(size, vector<int>(size, 0));
    
    for (int x = -m; x < n; x++) {
        for (int y = -m; y < n; y++) {
            int z = -x - y;
            if (z > -n && z < n) {
                int x_old = -y;
                int y_old = x + y;
                b[x + m][y + m] = a[x_old + m][y_old + m];
            }
        }
    }
    return b;
}

vector<vector<int>> reflect_transform(const vector<vector<int>>& a, int n) {
    int m = n - 1;
    int size = n + m;
    vector<vector<int>> b(size, vector<int>(size, 0));
    
    for (int x = -m; x < n; x++) {
        for (int y = -m; y < n; y++) {
            int z = -x - y;
            if (z > -n && z < n) {
                int x_old = x;
                int y_old = -x - y;
                b[x + m][y + m] = a[x_old + m][y_old + m];
            }
        }
    }
    return b;
}

int main() {
    int n;
    while (cin >> n) {
        cin.ignore();
        int m = n - 1;
        int size = n + m;
        vector<vector<int>> a(size, vector<int>(size, 0));

        for (int x = -m; x < n; x++) {
            string line;
            getline(cin, line);
            stringstream ss(line);
            for (int y = -m; y < n; y++) {
                int z = -x - y;
                if (z > -n && z < n) {
                    ss >> a[x + m][y + m];
                }
            }
        }

        string cmd;
        getline(cin, cmd);
        
        int mult = 1;
        int rotate = 0;
        for (char v : cmd) {
            switch (v) {
                case 'L': 
                    rotate = (rotate + 6 - mult) % 6;
                    if (rotate < 0) rotate += 6;
                    break;
                case 'R': 
                    rotate = (rotate + mult) % 6;
                    if (rotate < 0) rotate += 6;
                    break;
                case 'T': 
                    mult *= -1;
                    break;
                default: 
                    assert(false);
            }
        }

        for (int i = 0; i < rotate; i++) {
            a = rotate_transform(a, n);
        }
        if (mult < 0) {
            a = reflect_transform(a, n);
        }

        for (int x = -m; x < n; x++) {
            cout << string(abs(x) * 2, ' ');
            for (int y = -m; y < n; y++) {
                int z = -x - y;
                if (z > -n && z < n) {
                    cout << setw(4) << a[x + m][y + m];
                }
            }
            cout << endl;
        }
    }
    return 0;
}