// Author: Ivan Kazmenko (gassa@mail.ru)
// Checker for problem "hex-operations":
// * compare tokens in lines with arbitrary spaces
// * check the total size of output against the limit
module check;
import std.format;
import std.range;
import std.string;
import testlib;

immutable int maxT = 1 << 23;

void main (string [] args)
{
	initTestlib !(TestlibRole.checker) (args);

	auto outLines = outFile.byLine;
	auto ansLines = ansFile.byLine;
	int lineNumber = 0;
	string [] reportLines;
	int total = 0;
	foreach (outLine, ansLine; zip (outLines, ansLines))
	{
		lineNumber += 1;
		total += outLine.length + 1;
		if (total > maxT)
		{
			quit (ExitCode.wa, "at least ", total, " > ",
			    maxT, " bytes in output");
		}

		auto outTokens = outLine.split;
		auto ansTokens = ansLine.split;
		if (outTokens.length != ansTokens.length)
		{
			quit (ExitCode.wa, "line ", lineNumber, ": ",
			    outTokens.length, " tokens instead of ",
			    ansTokens.length);
		}
		foreach (i; 0..outTokens.length)
		{
			if (outTokens[i] != ansTokens[i])
			{
				quit (ExitCode.wa, "line ", lineNumber,
				    ", token ", i + 1, ": '",
				    outTokens[i].shorten, "' instead of `",
				    ansTokens[i].shorten, "'");
			}
		}
	}
	if (!outLines.empty)
	{
		quit (ExitCode.pe, "extra lines: more than ", lineNumber);
	}
	if (!ansLines.empty)
	{
		quit (ExitCode.pe, "not enough lines: ", lineNumber);
	}
	outFile.checkEof ();
	ansFile.checkEof ();
	quit (ExitCode.ok, lineNumber, " lines");
}
