import java.util.Arrays;
import java.util.Scanner;

public class Main {
    static final int a = 1;
    static final int p = 618023;
    static final int m = 999983;

    static class BitSet {
        long[] a = new long[(m + 63) / 64 + 1];

        long get(int pos) {
            return (a[pos >> 6] >>> (pos & 63)) & 1;
        }

        void assign(boolean val, int pos) {
            if (pos < 0) {
                return;
            }
            long shift = pos & 63;
            long mask = 1L << shift;
            a[pos >> 6] = (a[pos >> 6] & ~mask) ^ (val ? (1L << shift) : 0);
        }
    }

    static int solve(int n, int s) {
        int total = 0;
        BitSet fwd = new BitSet();
        BitSet[] rev = new BitSet[64];
        for (int i = 0; i < 64; i++) {
            rev[i] = new BitSet();
        }

        for (int i = 0; i < n; i++) {
            s = (int) (((long) s * p + a) % m);
            long cur = 0;
            int lim = s / 2 + 1;
            int start = m - s;
            int startDiv = start >> 6;
            int startMod = start & 63;
            int startAligned = startDiv << 6;
            int full = lim / 64;

            for (int y = 0; y < full; y++) {
                cur ^= fwd.a[y] & rev[startMod].a[startDiv + y];
            }
            for (int x = full * 64; x < lim; x++) {
                cur ^= fwd.get(x) & rev[startMod].get(startAligned + x);
            }
            if (Long.bitCount(cur) % 2 == 0) {
                fwd.assign(true, s);
                for (int b = 0; b < 64; b++) {
                    rev[b].assign(true, (int) (m - s - b));
                }
                total += 1;
            }
        }
        return total;
    }

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        while (scanner.hasNextInt()) {
            int n = scanner.nextInt();
            int s = scanner.nextInt();
            System.out.println(solve(n, s));
        }
        scanner.close();
    }
}
