/**
 *    author:  tourist
 *    created: 05.11.2025 20:58:16
**/
#include <bits/stdc++.h>

using namespace std;

#ifdef LOCAL
#include "algo/debug.h"
#else
#define debug(...) 42
#endif

const int inf = int(1e9);

template <typename T, typename F>
class SparseTable {
 public:
  int n;
  vector<vector<T>> mat;
  F func;

  SparseTable(const vector<T>& a, const F& f) : func(f) {
    n = static_cast<int>(a.size());
    int max_log = 32 - __builtin_clz(n);
    mat.resize(max_log);
    mat[0] = a;
    for (int j = 1; j < max_log; j++) {
      mat[j].resize(n - (1 << j) + 1);
      for (int i = 0; i <= n - (1 << j); i++) {
        mat[j][i] = func(mat[j - 1][i], mat[j - 1][i + (1 << (j - 1))]);
      }
    }
  }

  T get(int from, int to) const {
    assert(0 <= from && from <= to && to <= n - 1);
    int lg = 32 - __builtin_clz(to - from + 1) - 1;
    return func(mat[lg][from], mat[lg][to - (1 << lg) + 1]);
  }
};

int main() {
  ios::sync_with_stdio(false);
  cin.tie(nullptr);
  int tt;
  cin >> tt;
  while (tt--) {
    int n, xa, xb;
    cin >> n >> xa >> xb;
    vector<int> xs = {xa, xb};
    vector<int> xk(n), xl(n);
    int x_left = -inf;
    int x_right = inf;
    for (int i = 0; i < n; i++) {
      cin >> xk[i] >> xl[i];
      xs.push_back(xk[i]);
      xs.push_back(xl[i]);
      if (xa < xl[i] && xl[i] < xk[i]) {
        x_right = min(x_right, xl[i]);
      }
      if (xa > xl[i] && xl[i] > xk[i]) {
        x_left = max(x_left, xl[i]);
      }
    }
    sort(xs.begin(), xs.end());
    vector<int> kfl_min(2 * n + 2, inf);
    vector<int> kfl_max(2 * n + 2, -inf);
    for (int i = 0; i < n; i++) {
      int il = int(lower_bound(xs.begin(), xs.end(), xl[i]) - xs.begin());
      kfl_min[il] = kfl_max[il] = xk[i];
    }
    int ia = int(lower_bound(xs.begin(), xs.end(), xa) - xs.begin());
    kfl_min[ia] = kfl_max[ia] = xa;
    SparseTable st_min(kfl_min, [&](int a, int b) {
      return min(a, b);
    });
    SparseTable st_max(kfl_max, [&](int a, int b) {
      return max(a, b);
    });
    int64_t ans = abs(xa - xb);
    for (int it = 0; it < n + 1; it++) {
      if (xb < x_left || xb > x_right) {
        ans = -1;
        break;
      }
      int ib = int(lower_bound(xs.begin(), xs.end(), xb) - xs.begin());
      if (xa < xb) {
        xb = st_min.get(ia, ib);
      } else {
        xb = st_max.get(ib, ia);
      }
      ans += 2 * abs(xa - xb);
    }
    if (xa != xb) {
      ans = -1;
    }
    cout << ans << '\n';
  }
  return 0;
}
