#define whole(x) x.begin(), x.end()
#define X first
#define Y second
#define TIME_FOR_PAIR_OF_KEY_AND_LOCK 0
#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;
using vi = vector<int>;
using pii = pair<int, int>;
using vpii = vector<pii>;
using ll = long long;
using vl = vector<ll>;
using vvl = vector<vl>;
int main() {
    ios::sync_with_stdio(false); cin.tie(nullptr);
    const ll INF = 1e18;
    int t;
    cin >> t;
    for (; t--;) {
        int n, e, q;
        cin >> n >> e >> q;
        vi k(n), l(n);
        const int N = 2 * n + 2;
        vpii p(N);
        for (int i = 0; i < n; ++i) {
            cin >> k[i] >> l[i];
            p[2 * i] = {k[i], i};
            p[2 * i + 1] = {l[i], -i - 1};
        }
        p[2 * n] = {e, n};
        p[2 * n + 1] = {q, -n - 1};
        sort(whole(p));
        vvl dp(N, vl(N, INF));
        for (int i = 0; i < N; ++i)
            if (p[i].X == e)
                dp[i][i] = 0;
        ll ans = INF;
        for (int length = 1; length < N; ++length) {
            for (int start = 0; start < N; ++start) {
                vector<int> ends;
                if (start - length >= 0)
                    ends.push_back(start - length);
                if (length != 0 && start + length < N)
                    ends.push_back(start + length);
                for (int end : ends) {
                    int left = min(start, end);
                    int right = max(start, end);
#ifdef SPEED_UP2
                    if (p[left].X > e || p[right].X < e)
                        continue;
#endif
                    int new_left = left, new_right = right;
                    if (left == end)
                        ++new_left;
                    else
                        --new_right;
                    for (int new_end : {new_left, new_right}) {
                        int new_start = new_left + new_right - new_end;
#ifdef SPEED_UP1
                        if (dp[new_start][new_end] == INF)
                            continue;
#endif
                        const int lock_index = -1 - p[new_end].Y;
                        bool is_lock = lock_index >= 0 && lock_index < n;
                        if (is_lock && !(k[lock_index] >= p[new_left].X && k[lock_index] <= p[new_right].X))
                            continue;
                        dp[start][end] = min(dp[start][end], dp[new_start][new_end] + abs(p[end].X - p[new_end].X) + TIME_FOR_PAIR_OF_KEY_AND_LOCK * is_lock);
                    }
                    if (p[end].X == q)
                        ans = min(ans, dp[start][end]);
                }
#ifdef SPEED_UP3
                if (ans != INF)
                    break;
#endif
            }
#ifdef SPEED_UP3
            if (ans != INF)
                break;
#endif
        }
        cout << (ans == INF ? -1 : ans) << '\n';
    }
}
