#define TIME_FOR_PAIR_OF_KEY_AND_LOCK 0

#include <iostream>
#include <vector>
#include <algorithm>

using Coordinate = int32_t;
using PathLength = int64_t;
using Index = uint32_t;
using SignedIndex = std::make_signed_t<Index>;

const PathLength IMPOSSIBLE_LENGTH = -1;

struct KeyLock {
    Coordinate key, lock;
};

std::istream& operator>>(std::istream& in, KeyLock& key_lock) {
    return in >> key_lock.key >> key_lock.lock;
}

struct Instance {
    std::vector<KeyLock> key_locks;
    Coordinate start, finish;
};

std::istream& operator>>(std::istream& in, Instance& instance) {
    Index n = 0;
    in >> n >> instance.start >> instance.finish;
    instance.key_locks.resize(n);
    for (KeyLock& key_lock : instance.key_locks)
        in >> key_lock;
    return in;
}

enum ActionType {
    GO, PICK, UNLOCK
};

std::ostream& operator<<(std::ostream& out, const ActionType action_type) {
    if (action_type == GO)
        out << "go";
    else if (action_type == PICK)
        out << "pick";
    else
        out << "unlock";
    return out;
}

struct Action {
    ActionType type;
    Coordinate x;
};

std::ostream& operator<<(std::ostream& out, const Action action) {
    return out << action.type << ' ' << action.x;
}

struct Actions {
    std::vector<Action> v;
};

std::ostream& operator<<(std::ostream& out, const Actions& actions) {
    out << actions.v.size() << '\n';
    for (const Action action : actions.v)
        out << action << '\n';
    return out;
}

struct Solution {
    PathLength length;
    Actions actions;
};

const Coordinate MIN_X = -1'000'000, MAX_X = 1'000'000;

Solution find_ans(const Instance& instance) {
    static std::vector<SignedIndex> at_point(MAX_X - MIN_X + 1);
    const Index n = instance.key_locks.size();
    Coordinate min_x = std::min(instance.start, instance.finish), max_x = std::max(instance.start, instance.finish);
    for (Index i = 0; i < n; ++i) {
        min_x = std::min(min_x, std::min(instance.key_locks[i].key, instance.key_locks[i].lock));
        max_x = std::max(max_x, std::max(instance.key_locks[i].key, instance.key_locks[i].lock));
    }
    const Coordinate M = max_x - min_x + 1;
    auto clean = [&]() {
        std::fill(at_point.begin(), at_point.begin() + M, 0);
    };
    auto enc = [&](Coordinate x) {
        return x - min_x;
    };
    auto is_lock = [&](int i) {
        return at_point[i] <= -1 && at_point[i] >= -n;
    };
    at_point[enc(instance.start)] = n + 1;
    at_point[enc(instance.finish)] = -n - 1;
    for (Index i = 0; i < n; ++i) {
        at_point[enc(instance.key_locks[i].key)] = i + 1;
        at_point[enc(instance.key_locks[i].lock)] = -i - 1;
    }
    std::vector<Coordinate> required_points(M);
    const Index IMPOSSIBLE_INDEX = M;
    required_points[enc(instance.start)] = enc(instance.start);
    for (Index i = enc(instance.start) + 1; i < M; ++i) {
        required_points[i] = required_points[i - 1];
        if (is_lock(i) && required_points[i] != IMPOSSIBLE_INDEX) {
            Coordinate key_x = enc(instance.key_locks[-1 - at_point[i]].key);
            required_points[i] = (key_x > i) ?
                                 IMPOSSIBLE_INDEX :
                                 std::min(required_points[i], key_x);
        }
    }
    for (Index i = enc(instance.start) - 1; i + 1 > 0; --i) {
        required_points[i] = required_points[i + 1];
        if (is_lock(i) && required_points[i] != IMPOSSIBLE_INDEX) {
            Coordinate key_x = enc(instance.key_locks[-1 - at_point[i]].key);
            required_points[i] = (key_x < i) ?
                                 IMPOSSIBLE_INDEX :
                                 std::min(required_points[i], key_x);
        }
    }
    std::vector<Coordinate> destination{enc(instance.finish)};
    while (destination.back() != enc(instance.start)) {
        if (destination.back() == IMPOSSIBLE_INDEX) {
            clean();
            return {.length = IMPOSSIBLE_LENGTH, .actions = {}};
        }
        destination.push_back(required_points[destination.back()]);
        if (destination.size() >= 3 && (
            destination.rbegin()[2] <= destination.rbegin()[0] && destination.rbegin()[0] > enc(instance.start)
                ||
            destination.rbegin()[2] >= destination.rbegin()[0] && destination.rbegin()[0] < enc(instance.start)
        )) {
            clean();
            return {.length = IMPOSSIBLE_LENGTH, .actions = {}};
        }
    }
    const Coordinate final_l_index = std::min(destination[0], destination[1]),
                     final_r_index = std::max(destination[0], destination[1]);
    destination.pop_back();
    std::reverse(destination.begin(), destination.end());
    Coordinate L = enc(instance.start), R = enc(instance.start);
    Solution solution{.length = 0, .actions = {}};
    for (Coordinate i = final_l_index; i <= final_r_index; ++i)
        if (is_lock(i))
            solution.length += TIME_FOR_PAIR_OF_KEY_AND_LOCK;
    for (Index d : destination) {
        Coordinate direction = d > enc(instance.start) ? 1 : -1;
        Coordinate previous_stop = direction == 1 ? L : R;
        Coordinate& current_start = direction == 1 ? R : L;
        solution.length += direction * (d - previous_stop);
        current_start = d;
    }
    clean();
    return solution;
}

bool solve_test([[maybe_unused]] const Index test_index) {
    Instance instance;
    if (!(std::cin >> instance))
        return false;
    Solution solution = find_ans(instance);
    std::cout << solution.length << '\n';
    return true;
}

void solve_tests() {
    Index n_tests;
    std::cin >> n_tests;
    for (Index test_index = 0; test_index < n_tests; ++test_index)
        if (!solve_test(test_index))
            return;
}

int main() {
    std::ios::sync_with_stdio(false);
    std::cin.tie(nullptr);
    solve_tests();
}
