#include <algorithm>
#include <array>
#include <bitset>
#include <cassert>
#include <chrono>
#include <cstdint>
#include <cstring>
#include <functional>
#include <iomanip>
#include <iostream>
#include <map>
#include <numeric>
#include <queue>
#include <random>
#include <set>
#include <stack>
#include <vector>

using namespace std;

// BEGIN NO SAD
#define rep(i, a, b) for(int i = a; i < (b); ++i)
#define trav(a, x) for(auto& a : x)
#define all(x) x.begin(), x.end()
#define sz(x) (int)(x).size()
#define mp make_pair
#define pb push_back
#define eb emplace_back
#define lb lower_bound
#define ub upper_bound
typedef vector<int> vi;
#define f first
#define s second
#define derr if(1) cerr

// thanks gena
#ifdef LOCAL
#include "algo/debug.h"
#else
#define debug(...) 67
#endif

// END NO SAD

template<class Fun>
class y_combinator_result {
  Fun fun_;
public:
  template<class T>
  explicit y_combinator_result(T &&fun): fun_(std::forward<T>(fun)) {}

  template<class ...Args>
  decltype(auto) operator()(Args &&...args) {
    return fun_(std::ref(*this), std::forward<Args>(args)...);
  }
};

template<class Fun>
decltype(auto) y_combinator(Fun &&fun) {
  return y_combinator_result<std::decay_t<Fun>>(std::forward<Fun>(fun));
}

template<class T>
bool updmin(T& a, T b) {
  if(b < a) {
    a = b;
    return true;
  }
  return false;
}
template<class T>
bool updmax(T& a, T b) {
  if(b > a) {
    a = b;
    return true;
  }
  return false;
}
typedef int64_t ll;

const int LOCK = -67;
const int KEY = -6767;
void rsolve() {
  int n, src, dst;
  cin >> n >> src >> dst;
  vector<int> keyv(n), lockv(n);
  set<array<int, 3>> problems;
  for(int i = 0; i < n; i++) {
    cin >> keyv[i] >> lockv[i];
    if(src < keyv[i] && keyv[i] < lockv[i] && lockv[i] < dst) continue;
    if(src > keyv[i] && keyv[i] > lockv[i] && lockv[i] > dst) continue;
    if(src < dst && src > keyv[i] && keyv[i] > lockv[i]) continue;
    if(src > dst && src < keyv[i] && keyv[i] < lockv[i]) continue;
    problems.insert({lockv[i], keyv[i], i});
  }
  set<array<int, 3>> relevant;
  int lhs = min(src, dst);
  int rhs = max(src, dst);
  while(true) {
    auto it = problems.lb({lhs, int(-1e9), int(-1e9)});
    if(it == problems.end() || (*it)[0] > rhs) break;
    int loc = (*it)[1];
    updmin(lhs, loc);
    updmax(rhs, loc);
    relevant.insert(*it);
    problems.erase(it);
  }
  ll ret = 8e18;
  for(int init = -1; init <= 1; init += 2) {
    vector<bool> owned(n+1);
    set<array<int, 3>> interesting;
    interesting.insert({int(1e9), n, LOCK});
    interesting.insert({int(-1e9), n, LOCK});
    for(auto [lockloc, keyloc, idx]: relevant) {
      interesting.insert({lockloc, idx, LOCK});
      interesting.insert({keyloc, idx, KEY});
    }
    int curr = src;
    ll cand = 0;
    bool valid = true;
    int cdir = init;
    int swaps = 0;
    while(valid) {
      auto it = interesting.lb({curr, -1, -1});
      if(cdir == -1) {
        assert(it != interesting.begin()); it--;
      }
      debug(curr, *it);

      if(cdir == 1 && dst > curr && (*it)[0] > dst) {
        cand += dst - curr;
        curr = dst;
        break;
      }
      if(cdir == -1 && dst < curr && (*it)[0] < dst) {
        cand += curr - dst;
        curr = dst;
        break;
      }

      if((*it)[2] == LOCK && !owned[(*it)[1]]) {
        if(++swaps == 2) {
          valid = false; break;
        }
        cdir *= -1;
        continue;
      }
      swaps = 0;
      if((*it)[2] == LOCK) {
        assert(owned[(*it)[1]]);
        interesting.erase(it);
        continue;
      }
      assert((*it)[2] == KEY);
      cand += abs(curr - (*it)[0]);
      curr = (*it)[0];
      owned[(*it)[1]] = true;
      interesting.erase(it);
    }
    if(valid && curr == dst) {
      updmin(ret, cand);
    }
  }
  if(ret == 8e18) ret = -1;
  cout << ret << "\n";
}
void solve() {
  int q;
  cin >> q;
  while(q--) {
    rsolve();
  }
}

// what would chika do
// are there edge cases (N=1?)
// are array sizes proper (scaled by proper constant, for example 2* for koosaga tree)
// integer overflow?
// are you doing geometry in floating points
// have you tried rereading the problem statement

int main() {
  ios_base::sync_with_stdio(false);
  cin.tie(NULL);
  solve();
}
