#include <bits/stdc++.h>
using namespace std;

using ll = int64_t;
void solve(){
	int N, S, E;
	cin >> N >> S >> E;
	vector<vector<int> > gates(N, vector<int>(2));
	for(int a = 0; a < N; a++){
		cin >> gates[a][0] >> gates[a][1];
	}
	vector<int> bad(N);
	for(int a = 0; a < N; a++){
		if(gates[a][0] < gates[a][1] && gates[a][1] < S){
			bad[a] = 1;
		}
		if(gates[a][0] > gates[a][1] && gates[a][1] > S){
			bad[a] = 1;
		}
	}
	vector<tuple<int,int,int> > everything;
	for(int a = 0; a < N; a++){
		everything.push_back({gates[a][0], a, 0});
		everything.push_back({gates[a][1], a, 1});
	}
	everything.push_back({S, -1, -1});
	everything.push_back({E, -1, -2});
	sort(everything.begin(), everything.end());

	vector<vector<int> > gate_idx(N, vector<int>(2));

	int L = (int)everything.size();
	int idxS = -1;
	int idxE = -1;
	for(int i = 0; i < L; i++){
		auto [loc, label, type] = everything[i];
		if(type >= 0){
			gate_idx[label][type] = i;
		} else if(type == -1){
			idxS = i;
		} else if(type == -2){
			idxE = i;
		}
	}
	assert(idxS >= 0 && idxE >= 0);

	vector<int> need(L, idxS);
	for(int i = idxS+1; i < L; i++){
		auto [loc, label, type] = everything[i];
		need[i] = need[i-1];
		if(type == 1){
			need[i] = min(need[i], gate_idx[label][0]);
			if(bad[label]){
				need[i] = -1;
			}
		}
	}
	for(int i = idxS-1; i >= 0; i--){
		auto [loc, label, type] = everything[i];
		need[i] = need[i+1];
		if(type == 1){
			need[i] = max(need[i], gate_idx[label][0]);
			if(bad[label]){
				need[i] = L;
			}
		}
	}
	ll ans = 0;
	int cur = idxE;
	vector<int> seen(L, 0);
	while(cur != idxS){
		if(seen[cur]){
			ans = -1;
			break;
		}
		seen[cur] = 1;
		auto [loc, label, type] = everything[cur];
		ans += abs(loc - S);
		cur = need[cur];
		if(cur < 0 || cur >= L){
			ans = -1;
			break;
		}
		auto [nloc, nlabel, ntype] = everything[cur];
		ans += abs(nloc - S);
	}
	cout << ans << '\n';
}

int main(){
	ios_base::sync_with_stdio(false), cin.tie(nullptr);
	int T;
	cin >> T;
	while(T--) solve();
}
