import sys


def precalc(k):
    visitedStates = set()
    results = {}

    def go(state, score):
        state.sort()
        key = (score, tuple(state))
        if key in visitedStates:
            return
        visitedStates.add(key)

        if score not in results:
            results[score] = state

        if len(state) < k:
            go(state + [4], score)
            go(state + [2], score)

        for x in set(state):
            if state.count(x) >= 2:
                newState = state[:]
                newState.remove(x)
                newState.remove(x)
                newState.append(x * 2)
                go(newState, score + x * 2)

    sys.setrecursionlimit(10**7)
    go([], 0)
    return results


def main():
    n, k = map(int, input().split())
    results = precalc(k)
    for _ in range(n):
        h = int(input())
        result = results.get(h, None)
        if result is None:
            print(-1)
        else:
            print(len(result), *result)


if __name__ == '__main__':
    main()
