#include "testlib.h"

const int N = 5'000;

const std::string YES = "yes";
const std::string NO = "no";

int dist(const std::string& s1, const std::string& s2) {
    int n = (int)s1.size();
    int m = (int)s2.size();

    std::vector<std::vector<int>> dp(n + 1, std::vector<int>(m + 1));
    for (int i = 0; i <= n; ++i) {
        dp[i][0] = i;
    }
    for (int j = 0; j <= m; ++j) {
        dp[0][j] = j;
    }
    for (int i = 1; i <= n; ++i) {
        for (int j = 1; j <= m; ++j) {
            dp[i][j] = std::min(dp[i - 1][j] + 1, dp[i][j - 1] + 1);
            int add = (int)(s1[i - 1] != s2[j - 1]);
            dp[i][j] = std::min(dp[i][j], dp[i - 1][j - 1] + add);
        }
    }

    return dp[n][m];
}

bool check(InStream& in, int a, int b, int c) {
    std::string yesnoToken = in.readWord("[a-zA-Z]{1,3}", "token");
    if (lowerCase(yesnoToken) == NO) {
        return false;
    }
    if (lowerCase(yesnoToken) != YES) {
        in.quitf(_wa, "Unexpected token: %s, yes/no expected", yesnoToken.c_str());
    }

    const std::string pattern = format("[a-z]{1,%d}", N);
    std::string s1 = in.readWord(pattern.c_str(), "s1");
    std::string s2 = in.readWord(pattern.c_str(), "s2");
    std::string s3 = in.readWord(pattern.c_str(), "s3");

    if (dist(s1, s2) != a) {
        in.quitf(_wa, "dist(%s, %s) != %d", s1.c_str(), s2.c_str(), a);
    }
    if (dist(s1, s3) != b) {
        in.quitf(_wa, "dist(%s, %s) != %d", s1.c_str(), s3.c_str(), b);
    }
    if (dist(s2, s3) != c) {
        in.quitf(_wa, "dist(%s, %s) != %d", s2.c_str(), s3.c_str(), c);
    }

    return true;
}

int main(int argc, char** argv) {
    registerTestlibCmd(argc, argv);

    int a = inf.readInt();
    int b = inf.readInt();
    int c = inf.readInt();

    bool pa = check(ouf, a, b, c);
    bool ja = check(ans, a, b, c);

    if (!pa && ja) {
        quitf(_wa, "Participant didn't find the anwer, but it exists");
    } else if (pa && !ja) {
        quitf(_fail, "Participant found the answer, but jury didn't");
    } else {
        quitf(_ok, "OK");
    }

    return 0;
}
