import java.io.*;
import java.util.*;

public class Fast {
	FastScanner in;
	PrintWriter out;
	boolean systemIO = true;

	int n;
	int INF = 40000;

	int[] dx = { -1, -1, -1, 0, 0, 1, 1, 1 };
	int[] dy = { -1, 0, 1, -1, 1, -1, 0, 1 };
	
	public int request(int[] q) {
		System.out.println("? " + q[0] + " " + q[1]);
		String s = in.next();
		if (s.equals("0")) {
			System.exit(0);
		}
		return s.equals("W") ? 1 : 0;
	}
	
	public int toInt(int[] q) {
		return q[0] * INF + q[1];
	}
	
	@SuppressWarnings("unchecked")
	public void solve() {
		int[] sz = {0, 0};
		int[] q = {INF / 4, INF / 4};
		Queue<Integer> both = new ArrayDeque<>();
		ArrayList<Integer>[] ans = new ArrayList[2];
		HashSet<Integer>[] set = new HashSet[2];
		int h = toInt(q);
		both.add(h);
		for (int i = 0; i < 2; ++i) {
			ans[i] = new ArrayList<>();
			set[i] = new HashSet<>();
			set[i].add(h);
		}
		while (sz[0] < n && sz[1] < n) {
			if (!both.isEmpty()) {
				int key = both.poll();
				q[0] = key / INF;
				q[1] = key % INF;
				int c = request(q);
				++sz[c];
				ans[c].add(key);
				for (int k = 0; k < 8; ++k) {
					int x = q[0] + dx[k];
					int y = q[1] + dy[k];
					h = toInt(new int[]{x, y});
					if (set[c].add(h) && set[c^1].contains(h)) {
						both.add(h);
					}
				}
				continue;
			}
			int c = set[1].size() > set[0].size() ? 1 : 0;
			sz[c^1] = 0;
			ans[c^1].clear();
			for (int key : set[c]) {
				if (!set[c^1].contains(key)) {
					set[c^1].add(key);
					both.add(key);
					break;
				}
			}
		}
		int col = (sz[1] == n ? 1 : 0);
		if (col == 1) {
			System.out.print("! W");
		} else {
			System.out.print("! B");
		}
		for (int x : ans[col]) {
			System.out.print(" " + x / INF + " " + x % INF);
		}
		System.out.println();
	}
	
	public void run() {
		try {
			if (systemIO) {
				in = new FastScanner(System.in);
				out = new PrintWriter(System.out);
			} else {
				in = new FastScanner(new File("input.txt"));
				out = new PrintWriter(new File("output.txt"));
			}
			
			int t = in.nextInt();
			n = in.nextInt();
			
			for (int i = 0; i < t; ++i) {
				solve();
			}

			out.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	class FastScanner {
		BufferedReader br;
		StringTokenizer st;

		FastScanner(File f) {
			try {
				br = new BufferedReader(new FileReader(f));
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			}
		}

		FastScanner(InputStream f) {
			br = new BufferedReader(new InputStreamReader(f));
		}

		String nextLine() {
			try {
				return br.readLine();
			} catch (IOException e) {
				return null;
			}
		}

		String next() {
			while (st == null || !st.hasMoreTokens()) {
				try {
					st = new StringTokenizer(br.readLine());
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			return st.nextToken();
		}

		int nextInt() {
			String s = next();
			int res = 0;
			if (s.charAt(0) == '-') {
				for (int i = 1; i < s.length(); i++) {
					res = 10 * res + s.charAt(i) - '0';
				}
				return -res;
			}
			for (int i = 0; i < s.length(); i++) {
				res = 10 * res + s.charAt(i) - '0';
			}
			return res;
		}

		long nextLong() {
			return Long.parseLong(next());
		}

		double nextDouble() {
			return Double.parseDouble(next());
		}

	}

	public static void main(String[] arg) {
		new Fast().run();
	}
}
