import bisect
def get_infection_level(n, genome, queries):
    pos = [0] * n
    for i in range(n):
        pos[genome[i] - 1] = i 
    def process_segment(l, r):
        seq = []
        for i in range(l, r + 1):
            idx = pos[i - 1] 
            p = bisect.bisect_left(seq, idx)
            if p == len(seq):
                seq.append(idx)
            else:
                seq[p] = idx
        return len(seq)
    result = []
    for l, r in queries:
        result.append(str(process_segment(l - 1, r - 1))) 
    print("\n".join(result))
t = int(input())
for _ in range(t):
    n, q = map(int, input().split())
    genome = list(map(int, input().split()))
    queries = [tuple(map(int, input().split())) for _ in range(q)]
    get_infection_level(n, genome, queries)
