from itertools import permutations

n = int(input())
sync_ops = []
async_ops = []

for _ in range(n):
    parts = input().split()
    op, val, mode = parts[0], int(parts[1]), parts[2]
    if mode == 'sync':
        sync_ops.append((op, val))
    else:
        async_ops.append((op, val))

def apply_sync():
    A = 0
    for op, val in sync_ops:
        if op == '+':
            A += val
        elif op == '=':
            A = val
    return A

results = set()
for order in permutations(async_ops):
    A = apply_sync()
    for op, val in order:
        if op == '+':
            A += val
        elif op == '=':
            A = val
    results.add(A)

print(len(results))