#include <bits/stdc++.h>

using namespace std;

struct DSU {
    int n;
    vector<int> e, siz;
    DSU(int _n) {
        n = _n;
        e.resize(n);
        siz.assign(n, 1);
        iota(e.begin(), e.end(), 0);
    }
    int find(int u) {
        return (e[u] == u ? u : e[u] = find(e[u]));
    }
    bool merge(int v, int u) {
        v = find(v);
        u = find(u);
        if (v == u) {
            return false;
        }
        if (siz[v] > siz[u]) swap(v, u);
        e[v] = u;
        siz[u] += siz[v];
        return true;
    }
};

mt19937 rng(chrono::steady_clock().now().time_since_epoch().count());

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t, n;
    cin >> t >> n;
    
    while (t--) {
        
        map<pair<int, int>, int> used;
        auto ask = [&](int x, int y) {
            if (used.count(pair(x, y))) {
                return used[pair(x, y)];
            }
            cout << "? " << x << " " << y << endl;
            int res;
            char res2;
            cin >> res2;
            res = res2 == 'W';
            // int res = rng() % 2;
            used[pair(x, y)] = res;
            return res;
        };

        const int m = 155;
        vector<vector<int>> col(m, vector<int>(m));
        for (int i = 0; i < m; i++) {
            for (int j = 0; j < m; j++) {
                col[i][j] = ask(i, j);
            }
        }
        DSU dsu(m * m);
        for (int i = 0; i < m; i++) {
            for (int j = 0; j < m; j++) {
                vector<int> d = {-1, 0, 1};
                for (auto dx : d) {
                    for (auto dy : d) {
                        int ni = i + dx;
                        int nj = j + dy;
                        if (ni >= 0 && ni < m && nj >= 0 && nj < m && col[ni][nj] == col[i][j]) {
                            dsu.merge(m * i + j, m * ni + nj);
                        }
                    }
                }
            }
        }
       
        vector<pair<int, int>> com;
        queue<pair<int, int>> q;
        
        int mx = -1, mx_id = 0;
        for (int i = 0; i < m * m; i++) {
            if (dsu.siz[dsu.find(i)] > mx) {
                mx_id = dsu.find(i);
                mx = dsu.siz[mx_id];
            }
        }
        map<pair<int, int>, int> vis;
        for (int i = 0; i < m; i++) {
            for (int j = 0; j < m; j++) {
                if (q.empty() && dsu.find(i * m + j) == mx_id) {  
                    q.push(pair(i, j));
                    vis[pair(i, j)] = 1;
                } 
            }
        }
        
        
        while (!q.empty() && com.size() < n) {
            auto [i, j] = q.front();
            q.pop();
            com.push_back(pair(i, j));

            vector<int> d = {-1, 0, 1};
            for (auto dx : d) {
                for (auto dy : d) {
                    int ni = i + dx;
                    int nj = j + dy;
                    if (!vis.count(pair(ni, nj)) && ask(ni, nj) == ask(i, j)) {
                        vis[pair(ni, nj)] = 1;
                        q.push(pair(ni, nj));
                    }
                }
            }
        }
        cout << "! " << (ask(com.back().first, com.back().second) ? 'W' : 'B') << " ";
        for (auto [v, u] : com) {
           
            cout << v << " " << u << " ";;
        }
        cout << endl;
    }
    return 0;
}