#include <iostream>
#include <string>
#include <algorithm>

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int a, b, c;
    if (!(cin >> a >> b >> c)) {
        return 0;
    }

    if (a + b < c || a + c < b || b + c < a) {
        cout << "No\n";
        return 0;
    }

    int X = b + c - a;
    int Y = a + c - b;
    int Z = a + b - c;

    int parity = X & 1;
    int limit = min({X, Y, Z});
    if (limit < parity) {
        cout << "No\n";
        return 0;
    }

    int E = parity;
    int B = (X - E) / 2;
    int C = (Y - E) / 2;
    int D = (Z - E) / 2;

    string s, t, u;
    s.reserve(B + C + D + E + 1);
    t.reserve(B + C + D + E + 1);
    u.reserve(B + C + D + E + 1);

    auto append_block = [](string& x, char cx, string& y, char cy, string& z, char cz, int cnt) {
        for (int i = 0; i < cnt; ++i) {
            x.push_back(cx);
            y.push_back(cy);
            z.push_back(cz);
        }
    };

    append_block(s, 'a', t, 'a', u, 'b', B);
    append_block(s, 'c', u, 'c', t, 'd', C);
    append_block(t, 'e', u, 'e', s, 'f', D);
    append_block(s, 'g', t, 'h', u, 'i', E);

    if (s.empty() && t.empty() && u.empty()) {
        s = t = u = "a";
    }

    cout << "Yes\n";
    cout << s << '\n' << t << '\n' << u << '\n';
    return 0;
}
