import sys
input = sys.stdin.readline

t = int(input())
for _ in range(t):
    n = int(input())
    problems = [tuple(input().split()) for _ in range(n)]
    
    unused_by_first = {}
    unused_by_second = {}
    for i, (a, b) in enumerate(problems):
        unused_by_first.setdefault(a, set()).add(i)
        unused_by_second.setdefault(b, set()).add(i)
    
    valid = True
    for i in range(n - 1):
        a, b = problems[i]
        unused_by_first[a].discard(i)
        unused_by_second[b].discard(i)
        
        next_a, next_b = problems[i + 1]
        
        similar_exists = bool(unused_by_first[a] or unused_by_second[b])
        
        if similar_exists:
            if not (a == next_a or b == next_b):
                valid = False
                break
    
    print("Yes" if valid else "No")