#include <bits/stdc++.h>
using namespace std;

struct DSU {
    vector<int>par, sz, dpar;
    DSU(int n) {
        par.resize(n + 1);
        dpar.resize(n + 1);
        sz.resize(n + 1);
        for(int i = 1; i <= n; i++) this->make_set(i);
    }
    void make_set(int a) {
        par[a] = a;
        dpar[a] = -1;
        sz[a] = 1;
    }
    int find_set(int a) {
        if(a == par[a]) return a;
        return par[a] = find_set(par[a]);
    }
    void union_set(int a1, int b1) {
        int a = find_set(a1);
        int b = find_set(b1);
        if(a == b) return;
        if(sz[a] < sz[b]) swap(a, b);
        par[b] = a;
        dpar[b1] = a1;
        sz[a] += sz[b];
    }
};

int a = 3, b = 3;
vector<vector<bool>>v;
vector<pair<int, int>>ans;
vector<vector<bool>>visited;

int di[] = {-1, 1, 0, 0, 1, -1, -1, 1};
int dj[] = {0, 0, -1, 1, 1, -1, 1, -1};

void DFS(int i, int j, int clr) {
    if(i < 0 || j < 0 || i >= a || j >= b || visited[i][j] || v[i][j] != clr) return;
    visited[i][j] = true;
    ans.push_back({i, j});
    for(int k = 0; k < 8; k++) {
        DFS(i + di[k], j + dj[k], v[i][j]);
    }
}

int main() {
    int t, n;
    cin >> t >> n;
    while(t--) {
        DSU dsu(a * b);
        v.resize(a, vector<bool>(b));
        visited.resize(a, vector<bool>(b, false));
        ans.clear();
        for(int i = 0; i < b; i++) {
            cout << "? 0 " << i << endl;
            char c; cin >> c;
            v[0][i] = c == 'B';
        }
        for(int i = 1; i < a; i++) {
            cout << "? " << i << " 0" << endl;
            char c; cin >> c;
            v[i][0] = c == 'B';
        }
        for(int i = 1; i < a; i++) {
            for(int j = 1; j < b; j++) {
                cout << "? " << i << " " << j << endl;
                char c; cin >> c;
                v[i][j] = c == 'B';
            }
        }
        for(int i = 1; i < a; i++) {
            for(int j = 1; j < b; j++) {
                if(v[i][j] == v[i - 1][j - 1]) dsu.union_set(i * b + j, (i - 1) * b + j - 1);
                if(v[i][j] == v[i][j - 1]) dsu.union_set(i * b + j, i * b + j - 1);
                if(v[i][j] == v[i - 1][j]) dsu.union_set(i * b + j, (i - 1) * b + j);
            }
        }
        bool finish = false;
        for(int i = 1; i < a; i++) {
            for(int j = 1; j < b; j++) {
                int cell = dsu.find_set(i * b + j);
                if(dsu.sz[cell] >= n && !visited[i][j]) {
                    //cout << cell / b << " " << cell % b << endl;
                    DFS(cell / b, cell % b, v[cell / b][cell % b]);
                    cout << "! " << "WB"[v[cell / b][cell % b]] << " ";
                    for(int l = 0; l < n; l++) {
                        cout << ans[l].first << " " << ans[l].second << ' ';
                    }
                    finish = true;
                    break;
                }
            }
            if(finish) break;
        }
    }
}
