from sys import stdout
from functools import lru_cache

@lru_cache(maxsize=None)
def collatz_cost(n):
    if n == 1:
        return 0
    elif n % 2 == 0:
        next_n = n // 2
    else:
        next_n = 3 * n + 1
    return len(str(next_n)) + collatz_cost(next_n)

t = int(input())


for i in range(t):
    n = int(input())
    cost = collatz_cost(n)

    if cost < 707:
        while n > 1:
            print("collatz")
            stdout.flush()
            n = int(input())
            if n == 0:
                exit()
            if n == 1:
                break
        continue
    else:
        while n > 1:
            while n > 1 and n % 2 == 0:
                print("collatz")
                stdout.flush()
                n = int(input())
                if n == 0:
                    exit()
                if n == 1:
                    break
            
            if n == 1:
                break

            cost = collatz_cost(n)
            if cost < 707:
                print("collatz")
                stdout.flush()
                n = int(input())
                if n == 0:
                    exit()
                if n == 1:
                    break
            else:
                print("random")
                stdout.flush()
                n = int(input())
                if n == 0:
                    exit()
                if n == 1:
                    break
