def get_row_lengths(n):
    return [n + min(r, 2 * n - 2 - r) for r in range(2 * n - 1)]

def generate_cube_coordinates(n):
    radius = n - 1
    for z in range(-radius, radius + 1):
        x_min = max(-radius, -z - radius)
        x_max = min(radius, -z + radius)
        for x in range(x_min, x_max + 1):
            y = -x - z
            yield (x, y, z)

def apply_reflection(coord):
    x, y, z = coord
    return (y, x, z)

def apply_rotation(coord):
    x, y, z = coord
    return (-z, -x, -y)

def calculate_net_transformation(operations):
    rotation_amount = 0
    is_reflected = False
    
    for operation in operations:
        if operation == 'R':
            rotation_amount = (rotation_amount + 1) % 6
        elif operation == 'L':
            rotation_amount = (rotation_amount - 1) % 6
        elif operation == 'T':
            is_reflected = not is_reflected
            rotation_amount = (6 - rotation_amount) % 6
    
    return rotation_amount, is_reflected

def apply_transform(hex_rows, n, rotation_amount, is_reflected):
    values = [value for row in hex_rows for value in row]
    coordinates = list(generate_cube_coordinates(n))
    coordinate_to_value = {coord: val for coord, val in zip(coordinates, values)}
    
    source_mapping = {}
    for coord in coordinates:
        transformed_coord = coord
        
        if is_reflected:
            transformed_coord = apply_reflection(transformed_coord)
        
        for _ in range(rotation_amount % 6):
            transformed_coord = apply_rotation(transformed_coord)
        
        source_mapping[transformed_coord] = coord
    
    transformed_values = [coordinate_to_value[source_mapping[coord]] for coord in coordinates]
    
    result_rows = []
    index = 0
    for row_length in get_row_lengths(n):
        result_rows.append(transformed_values[index:index + row_length])
        index += row_length
    
    return result_rows

n = int(input().strip())
hex_rows = [list(map(int, input().split())) for _ in range(2 * n - 1)]
operations = input().strip()

rotation_amount, is_reflected = calculate_net_transformation(operations)
result = apply_transform(hex_rows, n, rotation_amount, is_reflected)

for row in result:
    print(' '.join(map(str, row)))

