def build_keyboard():
    keys = "ABCDEFG" * 7 + "ABC"
    note_map = {}
    for idx, letter in enumerate(keys):
        note_map.setdefault(letter, []).append(idx)
    return note_map

def check_reachability(current_positions, target_indices, max_distance=3):
    reachable = set()
    for target_idx in target_indices:
        if any(abs(target_idx - curr_idx) <= max_distance for curr_idx in current_positions):
            reachable.add(target_idx)
    return reachable

def can_perform_melody(sequence, keyboard_mapping):
    if not sequence:
        return True

    reachable_positions = set(keyboard_mapping[sequence[0]])

    for char in sequence[1:]:
        reachable_positions = check_reachability(
            reachable_positions, 
            keyboard_mapping[char]
        )
        if not reachable_positions:
            return False

    return True

keyboard = build_keyboard()
num_tests = int(input())

results = []
for _ in range(num_tests):
    song = input().strip()
    results.append("Yes" if can_perform_melody(song, keyboard) else "No")

print('\n'.join(results))
